#include "mbed.h"
#include "vt100.h"
#include "MAG3110.h"
#include "MSS.h"

#define MAG3110_I2C_ADDRESS (0x0E)

MAG3110   *mag3110 = 0 ;

vt100 *tty = 0 ;

void reportMAG3110(MAG3110 *mag, int x, int y)
{
    uint8_t status = 0 ;
    int16_t mX, mY, mZ ;
    float fx, fy, fz ;
    mag->activate() ;
    wait(0.01) ;
    status = mag->getStatus() ;
    while((status & 0x80) == 0) { // wait for ZYXOW
       wait(0.01) ;
       status = mag->getStatus() ;
    }

    tty->locate(x+5, y) ;
    printf("--- MAG3110 ---") ;
    tty->locate(x, y+4) ;
    printf("Temperature: %02X",mag->getTemp()) ;
    tty->locate(x, y+5) ;
    printf("status: 0x%02X",mag->getStatus()) ;
    tty->locate(x, y+6) ;
    printf("ctrl reg1: 0x%02X ", mag->getCtrlReg1()) ;
    printf("reg2: 0x%02X", mag->getCtrlReg2()) ;
    mX = mag->getX() ; // here reset takes place!
    mY = mag->getY() ;
    mZ = mag->getZ() ;
    fx = 10000 * (float)mX / (float)0x7FFF ;
    fy = 10000 * (float)mY / (float)0x7FFF ;
    fz = 10000 * (float)mZ / (float)0x7FFF ;
    tty->locate(x, y+1) ;
    printf("X : ") ;
    if (fx >= 0) { printf(" ") ; }
    printf("%.2f uT : 0x%08X     ", fx, mX) ;

    tty->locate(x, y+2) ;
    printf("Y : ") ;
    if (fy >= 0) { printf(" ") ; }
    printf("%.2f uT : 0x%08X     ", fy, mY) ;
    
    tty->locate(x, y+3) ;
    printf("Z : ") ;
    if (fz >= 0) { printf(" ") ; }  
    printf("%.2f uT : 0x%08X     ", fz, mZ) ;
    mag->standby() ;
}

int main() {
    int x = 4 ;
    int y = 2 ;
    uint8_t id ;
    
    tty = new vt100() ;
    tty->cls() ;

    mag3110 = new MAG3110(PIN_SDA,  PIN_SCL,  MAG3110_I2C_ADDRESS) ;
//    id = mag3110->getID() ;
//    printf("ID = 0x%02X\n\r", id) ;
    while(1) {
        reportMAG3110(mag3110, x, y) ;
        wait(0.2) ;
    }
}
