#include "mbed.h"
#include "vt100.h"
#include "MSS.h"
#include "IS31SE5000.h"

#define IS31SE5000_I2C_ADDRESS (0x55)

#define NONE_DETECTED      0x00
#define MOTION_DETECTED    0x01
#define PROXIMITY_DETECTED 0x02

vt100 *tty = 0 ;
IS31SE5000 *is31 = 0 ;
char *board = BOARD_NAME ;
uint8_t newEvent = NONE_DETECTED ;

#if defined (TARGET_KL25Z)
InterruptIn myInt(PIN_INT1) ;
#else
InterruptIn myInt(PIN_INT3) ;
#endif

void reportIS31SE5000(IS31SE5000 *is31, int x, int y)
{
    tty->locate(x, y) ;
    printf("reportIS31SE5000\n") ;
}

void reportMotion(IS31SE5000 *is31, int x, int y) 
{
    uint8_t data ;
    data = is31->getMD() ;
    tty->locate(x, y) ;
    printf("Motion Detected\n") ;
    tty->locate(x, y+2) ;
    switch(data) {
    case 0x01: // MD_PD2_PD1:
        printf(" PD2 -> PD1 \n") ;
        break ;
    case 0x02: // MD_PD1_PD2: 
        printf(" PD1 -> PD2 \n") ;
        break ;
    default:
        printf("Event 0x%02X\n", data) ;
        break ;
    }
}

void reportProximity(IS31SE5000 *is31, int x, int y) 
{
    uint8_t data ;
    tty->locate(x, y) ;
    printf("Proximity Detected\n") ;
    data = is31->getPD() ;
    tty->locate(x, y+2) ;
    switch(data) {
    case 0x01: // PD_BE_OFF:  
        printf("   Be OFF   \n") ;
        break ;  
    case 0x02: // PD_BE_CLOSE:
        printf("   Be Close \n") ;
        break ;
    default:
        printf("Event 0x%02X\n", data) ;
        break ;
    }     
}

void myISR(void)
{
    uint8_t mode ;
    newEvent = NONE_DETECTED ;
    
    if (is31) {
        mode = is31->getMode() ;
        switch(mode) {
        case 0x00: // MODE_MOTION:
            newEvent = MOTION_DETECTED ;
            break ;
        case 0x01: // MODE_PROXIMITY:
            newEvent = PROXIMITY_DETECTED ;
            break ;
        default:
            printf("Unknown mode\n") ;
            break ;
        }
    }
}

int main(void) {
    int event_count = 0 ;
    tty = new vt100() ;
    tty->cls() ;

    tty->locate(25, 1) ;
    printf("<<< %s >>>", board) ;
    
    tty->locate(25, 10) ;
    printf("\n") ;
    
    myInt.fall(&myISR) ;
    
    is31 = new IS31SE5000(PIN_SDA, PIN_SCL, IS31SE5000_I2C_ADDRESS) ;
    is31->motionMode() ;
    is31->activate() ;
    tty->locate(25, 3) ;
    printf("Motion Detect Mode\n") ;
    tty->locate(25, 10) ;
    printf("Proximity Mode    \n") ;  
    tty->locate(23, 3) ;
    printf("*\n") ;
    
    while(1) {
        if (newEvent != NONE_DETECTED) {
            event_count++ ;
            switch(newEvent) {
            case MOTION_DETECTED:
                reportMotion(is31, 25, 5) ;
                if (event_count > 5) {
                    tty->locate(23, 3) ;
                    printf("  ") ;
                    tty->locate(23, 10) ;
                    printf("*\n") ;
                    is31->proximityMode() ;
                    event_count = 0 ;
                }
                break ;
            case PROXIMITY_DETECTED:
                reportProximity(is31, 25, 12) ;
                if (event_count > 5) {
                    tty->locate(23, 10) ;
                    printf("  ") ;
                   tty->locate(23, 3) ;
                   printf("*\n") ;
                   is31->motionMode() ;
                   event_count = 0 ;
                }
                break ;
            default:
                printf("Unknown event 0x%02X\n", newEvent) ;
                break ;
            }
            newEvent = NONE_DETECTED ;
        }
        wait(0.1) ;
    }
}