#include "mbed.h"
#include "MSS.h"
#include "HIH6130.h"
#define HIH6130_I2C_ADDRESS (0x27)

HIH6130 *hih6130 = 0 ;

int main() {
    float humidity = 0 ;
    float temperature = 0 ;
    
    hih6130 = new HIH6130(PIN_SDA, PIN_SCL, HIH6130_I2C_ADDRESS) ;
        
    printf("=== test HIH6130 for %s (%s) ===\n", BOARD_NAME, __DATE__) ;
    printf("Temperature(c), Humidity(%%)\n") ;
    
    while(1) {
        hih6130->measure() ;
        wait(0.5) ;
        hih6130->getValue(&humidity, &temperature) ;
        printf("%.1f, %.1f\n", temperature, humidity) ;      
        wait(1) ;
    }
}
