#include "mbed.h"
#include "vt100.h"
#include "FXOS8700CQ.h"
#include "MSS.h"

/*
 * I2C address could be 0x1C, 0x1D, 0x1E, 0x1F 
 * 0x1E (SA1 = 0, SA0 = 0)
 * 0x1D (SA1 = 0, SA0 = 1)
 * 0x1C (SA1 = 1, SA0 = 0)
 * 0x1F (SA1 = 1, SA1 = 1)
 */
#define FXOS8700CQ_I2C_ADDRESS (0x1E)

vt100 *tty = 0 ;
FXOS8700CQ *fxos = 0 ;

int main() {
    int16_t accData[3], mgnData[3] ;
    tty = new vt100() ;
    tty->cls() ;
    
    fxos = new FXOS8700CQ(PIN_SDA, PIN_SCL, FXOS8700CQ_I2C_ADDRESS) ;
    fxos->init() ;
    
    printf("=== test FXOS8700CQ for %s (%s) ===\n", BOARD_NAME, __DATE__) ;
    printf("ACC_X, ACC_Y, ACC_Z, MGN_X, MGN_Y, MGN_Z\n") ;
    
    while(1) {
        fxos->readAccMgnData(accData, mgnData) ;
//        printf("ACC X[%d], Y[%d], Z[%d],  MGN X[%d], Y[%d], Z[%d]\n",
        printf("%6d, %6d, %6d, %6d, %6d, %6d\n",
            accData[0], accData[1], accData[2],
            mgnData[0], mgnData[1], mgnData[2]) ;
        wait(0.2) ;
    }
}
