#include "mbed.h"
#include "dumb_i2c.h"

DUMB_I2C::DUMB_I2C(PinName sda, PinName scl, int addr) : m_i2c(sda, scl), m_addr(addr<<1) {
    // activate the peripheral
    freq = 100000 ; /* 100KHz */
    m_i2c.frequency(freq) ;
}

DUMB_I2C::~DUMB_I2C() { }

uint8_t DUMB_I2C::address(void)
{
    return( m_addr >> 1 ) ;
}

void DUMB_I2C::frequency(uint32_t f)
{
    freq = f ;
    m_i2c.frequency(freq) ;
}

uint32_t DUMB_I2C::frequency(void)
{
    return(freq) ;
}

int DUMB_I2C::read(int addr, uint8_t *data, int len) 
{
    int result ;
    result = readRegs(addr, data, len) ;
    return( result ) ;
}

int DUMB_I2C::write(int addr, uint8_t *data, int len) 
{
    uint8_t *buf ;
    int ack ;
    buf = new uint8_t[len+1] ;
    buf[0] = addr ;
    for (int i = 0 ; i < len ; i++ ) {
        buf[i+1] = data[i] ;
    }
    ack = writeRegs(buf, len+1) ;
    delete buf ;
    return( ack ) ;
}

int DUMB_I2C::readRegs(int addr, uint8_t * data, int len) {
    int result ;
    char t[1] = {addr};
    m_i2c.write(m_addr, t, 1, true);
    result = m_i2c.read(m_addr, (char *)data, len);
    return( result ) ;
}

int DUMB_I2C::writeRegs(uint8_t * data, int len) {
    int ack ;
    ack = m_i2c.write(m_addr, (char *)data, len);
    return( ack ) ;
}