#include "mbed.h"
#include "vt100.h"
#include "MSS.h"
#include "FXAS21002.h"

#define FXAS21002_I2C_ADDRESS (0x20)

vt100 *tty = 0 ;
FXAS21002 *fxas = 0 ;

int main() {
    int16_t data[3] ;
    tty = new vt100() ;
    tty->cls() ;
    
    fxas = new FXAS21002(PIN_SDA, PIN_SCL, FXAS21002_I2C_ADDRESS) ;
    fxas->activate(true) ;
    
    printf("=== test FXAS21002 for %s (%s) ===\n", BOARD_NAME, __DATE__) ;
    printf("     X,      Y,      Z\n") ;
    
    while(1) {
        data[0] = fxas->getX() ;
        data[1] = fxas->getY() ;
        data[2] = fxas->getZ() ;
        printf("%6d, %6d, %6d\n", data[0], data[1], data[2]) ;
        wait(0.2) ;
    }
}