#include "mbed.h"
#include "MSS.h"
#include "VEML7700.h"

#ifndef MSU_VEML7700_I2C_ADDRESS
#define MSU_VEML7700_I2C_ADDRESS 0x10
#endif

VEML7700 *veml7700 = 0 ;

int main(void)
{
    uint16_t als, white ;
    
    veml7700 = new VEML7700(PIN_SDA, PIN_SCL, MSU_VEML7700_I2C_ADDRESS) ; 
    veml7700->setALSConf(0x0000) ;
    veml7700->setPowerSaving(0x0000) ;
    
    printf("=== VEML7700 test for %s (%s) ===\n",BOARD_NAME, __DATE__) ;   
    printf("  ALS,   White\n") ; 

    while(1) {
        als = veml7700->getALS() ;
        white = veml7700->getWHITE() ;
        printf("%6d, %6d\n", als, white) ;
        wait(2) ;
    }
}