#include "mbed.h"
#include "MSS.h"
#include "vt100.h"
#include "VEML6030.h"

#ifndef MSU_VEML6030_I2C_ADDRESS
#define MSU_VEML6030_I2C_ADDRESS 0x10
#endif

VEML6030 *veml6030 = 0 ;

vt100 *tty = 0 ;

int main(void)
{
    uint16_t als, white ;
    
    veml6030 = new VEML6030(PIN_SDA, PIN_SCL, MSU_VEML6030_I2C_ADDRESS) ;
    veml6030->setALSConf(0x0000) ; 
    veml6030->setPowerSaving(0x0000) ;

    tty = new vt100() ;
    tty->cls() ;

    printf("=== VEML6030 test for %s (%s)===\n", BOARD_NAME, __DATE__) ;   
    printf("Ambient, White\n") ; 
    
    while(1) {
        als = veml6030->getALS() ;
        white = veml6030->getWHITE() ;
        printf("%6d, %6d\n", als, white) ;
        wait(1) ;
    }
}