#include "mbed.h"
#include "VCNL4020.h"
#include "MSS.h"
#include "vt100.h"

#ifndef MSU_VCNL4020_I2C_ADDRESS
#define MSU_VCNL4020_I2C_ADDRESS 0x13
#endif

VCNL4020 *vcnl4020 = 0 ;

vt100 *tty = 0 ;

int main() {
    uint16_t als, prox ;

    tty = new vt100() ;
    tty->cls() ;
    
    vcnl4020 = new VCNL4020(PIN_SDA, PIN_SCL, MSU_VCNL4020_I2C_ADDRESS) ; 
    vcnl4020->setIrLedCurrent(1) ; /* 10mA for LED */
    vcnl4020->disableAlsPeriodic() ;
    vcnl4020->disableProxPeriodic() ;
    vcnl4020->disableSelfTimed() ;
    
    printf("=== test VCNL4020 (%s) %s ===\n", BOARD_NAME, __DATE__) ;
    printf("Product ID = %d, Revision = %d\n", 
        vcnl4020->getProdID(),
        vcnl4020->getRevID()) ;
    printf("Ambient Light, Proximity\n") ;
        
    while(1) {
        vcnl4020->trigBothOd() ; /* trigger both ALS and PROX */
        while(vcnl4020->alsDataReady() == 0) {
            /* wait for ambient light data ready */
        }
        als = vcnl4020->getAls() ;
        while(vcnl4020->proxDataReady() == 0) {
            /* wait for proximate data ready */
        }
        prox = vcnl4020->getProx() ;
        printf("%6d, %6d\n", als, prox) ;
        
        wait(1) ;
    }
}