#ifndef _DUMB_I2C_H_
#define _DUMB_I2C_H_

class DUMB_I2C
{
public:
  /**
  * DUMB_I2C constructor
  *
  * @param sda SDA pin
  * @param sdl SCL pin
  * @param addr addr of the I2C peripheral
  */
  DUMB_I2C(PinName sda, PinName scl, int addr);

  /**
  * HIH6130 destructor
  */
  ~DUMB_I2C();
  
  void frequency(uint32_t f) ;
  uint32_t frequency(void) ;
  uint8_t address(void) ;
  void start(void) ;
  void stop(void) ;
  int read(int addr, uint8_t *data, int len) ;
  int write(int addr, uint8_t *data, int len) ;
private:
  I2C m_i2c;
  int m_addr;
  uint32_t freq ;
  int readRegs(int addr, uint8_t * data, int len);
  int writeRegs(uint8_t * data, int len);
};

#endif /* _DUMB_I2C_H_ */