#ifndef MSU_H
#define MSU_H

#define MSU_MMA8451Q_ADDRESS   0x1C
#define MSU_MMA8452Q_ADDRESS   0x1D
#define MSU_MAG3110_ADDRESS    0x0E
#define MSU_HIH6130_ADDRESS    0x27
#define MSU_FXOS8700CQ_ADDRESS 0x1E
#define MSU_MAX44000_ADDRESS   0x4A
#define MSU_MAX44005_ADDRESS   0x44
#define MSU_MAX44008_ADDRESS   0x41
#define MSU_MAX30101_ADDRESS   0x57
#define MSU_MPL3115A2_ADDRESS  0x60
#define MSU_IS31SE5000_ADDRESS 0x55
#define MSU_VEML6040A_ADDRESS  0x10
#define MSU_VEML6075_ADDRESS   0x10
#define MSU_LM75B_ADDRESS      0x48
#define MSU_FXAS21002_ADDRESS  0x20
#define MSU_S11059_ADDRESS     0x2A
#define MAX30101_I2C_ADDRESS   0x57
#define MSU_VCNL4100_I2C_ADDRESS 0x60
#define MSU_AK09970N_I2C_ADDRESS 0x0C
#define MSU_AK9752_I2C_ADDRESS 0x64
#define MSU_AK9753_I2C_ADDRESS 0x66

typedef void (*fptr)(void) ;

typedef struct _i2c_sensor_struct {
    uint16_t address ;
    char *name ;
    fptr test_func ;
} i2c_sensor_type ;

void doDemo(void) ;
void testMMA8451Q(void) ;
void testMMA8452Q(void) ;
void testMAG3110(void) ;
void testHIH6130(void) ;
void testFXOS8700CQ(void) ;
void testMAX44000(void) ;
void testMAX44005(void) ;
void testMAX44008(void) ;
void testMAX30101(void) ;
void testMPL3115A2(void) ;
void testIS31SE5000(void) ;
void testVEML6040A(void) ;
void testVEML6075(void) ;
void testVCNL4100(void) ;
void testLM75B(void) ;
void testFXAS21002(void) ;
void testS11059(void) ;
void testMAX30101(void) ;
void testAK9752(void) ;
void testAK9753(void) ;
void testAK09970N(void) ;
    
extern i2c_sensor_type i2c_sensor[] ;
#endif