#include "mbed.h"
#include "MSS.h"
#include "LM75B.h"
#define LM75B_I2C_ADDRESS (0x48)

int main() {
    int8_t itemp = 0 ;
    float ftemp = 0.0 ;
    LM75B lm75b(PIN_SDA, PIN_SCL, LM75B_I2C_ADDRESS) ;
    
    printf("=== test LM75B for %s (%s) ===\n", BOARD_NAME, __DATE__) ;
    printf("Temperature (int) C, Temperature (float) C\n") ;
    
    while(1) {
        itemp = lm75b.temp() ;
        lm75b.getTemp(&ftemp) ;
//        printf("Temp = %d C degree,  %.3f C degree\n", itemp, ftemp) ;
        printf("%4d, %4.3f\n", itemp, ftemp) ;
        wait(1) ;
    }
}