#include "mbed.h"
#include <string.h>
#include <ctype.h>
#include "vt100.h"
#include "MSS.h"
#include "dumb_i2c.h"

DUMB_I2C *i2c = 0 ;
vt100 *tty = 0 ;

void doClose(void)
{
    if (i2c != 0) {
        printf("Closing I2C at 0x%02X ... ", i2c->address()) ;
        delete i2c ;
        i2c = 0 ;
        printf("Done\n") ;
    }
}

void doOpen(void)
{
    uint8_t address ;
    scanf("%X", &address) ;
    if (i2c != 0) {
        doClose() ;
    }
    printf("Opening I2C at 0x%02X ... ", address) ;
    i2c = new DUMB_I2C(PIN_SDA, PIN_SCL, address) ;
    printf("Done\n") ;
}

void doRead(void)
{
    int addr ;
    int len ;
    uint8_t *data ;
    int result ;
    if (i2c == 0) {
        printf("I2C is not opened\n") ;
        return ;
    }
    scanf("%X %X", &addr, &len) ;
    if (len > 0) {
        data = new uint8_t[len] ;
    }
 //   i2c->read(addr, data, len) ;
    printf("0x%02X : ", (unsigned int)addr) ;
    for (int i = 0 ; i < len ; i++ ) {
        result = i2c->read(addr+i, &data[i], 1) ;
        if (result == 0) {
            printf("%02X ", data[i]) ;
            if (((i+1) < len)&&(((i+1)%0x10) == 0)) {
                printf("\n") ;
                printf("0x%02X : ", (unsigned int)(addr + i + 1)) ;
            }
        } else {
            printf("failed to read 0x%02X\n", addr+i) ;
        }  
    }
    printf("\n") ;
}

void doWrite(void)
{
    int addr ;
    uint8_t len ;
    uint8_t data ;
    int ack ;
    if (i2c == 0) {
        printf("I2C is not opened\n") ;
        return ;
    }
    scanf("%X %X", &addr, &data) ;
    ack = i2c->write(addr, &data, 1) ;
    if (ack != 0) {
        printf("NAK at writing data[0x%02X] to address[0x%02X]\n",
            data, addr ) ;
    }
}

void doStatus(void)
{
    if (i2c == 0) {
        printf("i2c is not opened\n") ;
    } else {
        printf("i2c device at 0x%02X is opened at %d Hz\n", 
            i2c->address(), i2c->frequency()) ;
    }
}

void doHelp(void)
{
    printf("Simple I2C test program %s for %s\n", __DATE__, BOARD_NAME) ;
    printf("\n             === usage ===\n") ;
    printf("open <7bit addr>    : open i2c device at <7bit addr>\n") ;
    printf("close               : close currently opened i2c\n") ;
    printf("read <addr> <len>   : read <len> data from <addr>\n") ;
    printf("write <addr> <data> : write <data> to register <addr>\n") ;
    printf("frequency <freq>    : change frequency to <freq> Hz\n") ;
    printf("bus                 : bus scan for existing I2C addresses\n") ;
    printf("status              : print current status\n") ;
    printf("help                : print this help\n") ;
    printf("\nPlease set local-echo to see what you are typing.\n") ;
    printf("\n") ; 
}

void doFreq(void)
{
    int freq = 0 ;
    scanf("%d", &freq) ;
    if (i2c != 0) {
        i2c->frequency(freq) ;
    }
}

void doBusScan(void)
{
    int address ;
    uint8_t data ;
    int result ;
    if (i2c != 0) {
        printf("Closing I2C at 0x%02X ... ", i2c->address()) ;
        delete i2c ;
        i2c = 0 ;
        printf("Done\n") ;
    }

    for (address = 1; address < 127 ; address++) {
        i2c = new DUMB_I2C(PIN_SDA, PIN_SCL, address) ;
        result = i2c->read(address, &data, 1) ;
        if (result == 0) {
            printf("%02X ", address) ;
        }
        delete i2c ;
        i2c = 0 ; 
    }
    printf("\n") ;
}
    
void doCommand(char *str)
{
    switch(*str) {
    case 'o': case 'O': /* open */
        doOpen()    ; break ;
    case 'c': case 'C': /* close */
        doClose()   ; break ;
    case 'r': case 'R': /* read */
        doRead()    ; break ;
    case 'w': case 'W': /* write */
        doWrite()   ; break ;
    case 's': case 'S': /* status */
        doStatus()  ; break ;
    case 'f': case 'F': /* Frequency */
        doFreq()    ; break ;
    case 'b': case 'B': /* Bus Scan */
        doBusScan() ; break ;
    default:
        doHelp() ; break ;
    }
}

int main() {
    char cmd[32] ;
    tty = new vt100() ;
    tty->cls() ;
    doHelp() ;
    while(1) {
        printf("> ") ;
        scanf("%s", cmd) ;
        doCommand(cmd) ;
    }
}
