/* Copyright (c) 2013-2015 Design Methodology Lab
 * This driver was delived from MMA8451Q driver at mbed
*/
/*
* Copyright (c) 2010-2011 mbed.org, MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include "MMA8452Q.h"

#define REG_CTRL_REG_1    0x2A
#define REG_OUT_X_MSB     0x01
#define REG_OUT_X_LSB     0x02
#define REG_OUT_Y_MSB     0x03
#define REG_OUT_Y_LSB     0x04
#define REG_OUT_Z_MSB     0x05
#define REG_OUT_Z_LSB     0x06
#define REG_SYSMOD        0x0B
#define REG_WHO_AM_I      0x0D
#define REG_ZYZ_DATA_CFG  0x0E
#define REG_HP_FILTER_CUTOFF 0x0F
#define REG_PL_STATUS     0x10
#define REG_PL_CFG        0x11
#define REG_PL_COUNT      0x12
#define REG_PL_BF_ZCOMP   0x13
#define REG_P_L_THS_REG   0x14
#define REG_FF_MT_CFG     0x15
#define REG_FF_MT_SRC     0x16
#define REG_FF_MT_THS     0x17
#define REG_FF_MT_COUNT   0x18
#define REG_TRANSIENT_CFG 0x1D
#define REG_TRANSIENT_SRC 0x1E
#define REG_TRANSIENT_THS 0x1F
#define REG_TRANSIENT_COUNT 0x20
#define REG_PULSE_CFG     0x21
#define REG_PULSE_SRC     0x22
#define REG_PULSE_THSX    0x23
#define REG_PULSE_THSY    0x24
#define REG_PULSE_THSZ    0x25
#define REG_PULSE_TMLT    0x26
#define REG_PULSE_LTCY    0x27
#define REG_PULSE_WIND    0x28
#define REG_ASLP_COUNT    0x29
#define REG_CTRL_REG1     0x2A
#define REG_CTRL_REG2     0x2B
#define REG_CTRL_REG3     0x2C
#define REG_CTRL_REG4     0x2D
#define REG_CTRL_REG5     0x2E
#define REG_OFF_X         0x2F
#define REG_OFF_Y         0x30
#define REG_OFF_Z         0x31

#define UINT14_MAX        16383

MMA8452Q::MMA8452Q(PinName sda, PinName scl, int addr) : m_i2c(sda, scl), m_addr(addr<<1) {
    // activate the peripheral
    uint8_t data[2] = {REG_CTRL_REG_1, 0x01};
    writeRegs(data, 2);
}

MMA8452Q::~MMA8452Q() { }

uint8_t MMA8452Q::getWhoAmI() {
    uint8_t who_am_i = 0;
    readRegs(REG_WHO_AM_I, &who_am_i, 1);
    return who_am_i;
}

float MMA8452Q::getAccX() {
    return (float(getAccAxis(REG_OUT_X_MSB))/4096.0);
}

float MMA8452Q::getAccY() {
    return (float(getAccAxis(REG_OUT_Y_MSB))/4096.0);
}

float MMA8452Q::getAccZ() {
    return (float(getAccAxis(REG_OUT_Z_MSB))/4096.0);
}

void MMA8452Q::getAccAllAxis(float * res) {
    res[0] = getAccX();
    res[1] = getAccY();
    res[2] = getAccZ();
}

int16_t MMA8452Q::getAccAxis(uint8_t addr) {
    int16_t acc;
    uint8_t res[2];
    readRegs(addr, res, 2);

    acc = (res[0] << 6) | (res[1] >> 2);
    if (acc > UINT14_MAX/2)
        acc -= UINT14_MAX;

    return acc;
}

void MMA8452Q::readRegs(int addr, uint8_t * data, int len) {
    char t[1] = {addr};
    m_i2c.write(m_addr, t, 1, true);
    m_i2c.read(m_addr, (char *)data, len);
}

void MMA8452Q::writeRegs(uint8_t * data, int len) {
    m_i2c.write(m_addr, (char *)data, len);
}
