/**
 * MAX44008 RGB Color, Infrared,
 * and Temperature Sensor
 * I2C 7bit address: 0x40 (A0 = 1) 0x41 (A0 = 0)
 */

#ifndef _MAX44008_H_
#define _MAX44008_H_

#include "mbed.h"

class MAX44008
{
public:
 /**
 * MAX44008 constructor
 *
 * @param sda SDA pin
 * @param scl SCL pin
 * @param addr address of the I2C peripheral
 */
 MAX44008(PinName sda, PinName scl, int addr) ;
 
 ~MAX44008() ;

 /*
  * some member functions here (yet to be written)
  */
 int16_t getAMB_CLEAR(void) ;
 int16_t getAMB_RED(void) ;
 int16_t getAMB_GREEN(void) ;
 int16_t getAMB_BLUE(void) ;
 int16_t getIR(void) ;
 int16_t getIRCOMP(void) ;
 int16_t getTEMP(void) ;
 uint8_t getIntStatus(void) ;
 void    setIntStatus(uint8_t newValue) ;
 uint8_t getMainConfig(void) ;
 void    setMainConfig(uint8_t newConfig) ;
 uint8_t getAMB_Config(void) ;
 void    setAMB_Config(uint8_t newConfig) ;
 int16_t getAMB_UPTHR(void) ;
 void    setAMB_UPTHR(int16_t newTHR) ;
 int16_t getAMB_LOTHR(void) ;
 void    setAMB_LOTHR(int16_t newTHR) ;
 uint8_t getAMB_PST(void) ;
 void    setAMB_PST(uint8_t newValue) ;
 /* Ambient ADC Gains */
 uint8_t getTRIM_GAIN_CLEAR(void) ;
 void    setTRIM_GAIN_CLEAR(uint8_t newValue) ;
 uint8_t getTRIM_GAIN_RED(void) ;
 void    setTRIM_GAIN_RED(uint8_t newValue) ;
 uint8_t getTRIM_GAIN_GREEN(void) ;
 void    setTRIM_GAIN_GREEN(uint8_t newValue) ;
 uint8_t getTRIM_GAIN_BLUE(void) ;
 void    setTRIM_GAIN_BLUE(uint8_t newValue) ;
 uint8_t getTRIM_GAIN_IR(void) ;
 void    setTRIM_GAIN_IR(uint8_t newValue) ;
 
 void    enableTRIM(void) ;
 void    disableTRIM(void) ;
 void    enableCOMP(void) ;
 void    disableCOMP(void) ;
 void    enableTEMP(void) ;
 void    disableTEMP(void) ;
 void    enableAMBINT(void) ;
 void    disableAMBINT(void) ;
 void    selectAMBINT(uint8_t newChannel) ;
 void    setMode(uint8_t newMode) ;
 void    setRawMode(uint8_t newMode) ;
 
private:
  I2C m_i2c;
  int m_addr;
  void readRegs(int addr, uint8_t *data, int len) ;
  void writeRegs(uint8_t *data, int len) ;
} ;
#endif /* _MAX44008_H_ */