/**
 * MAX44005 RGB Color, Temperature,
 * and Infrared Proximity Sensor
 * I2C 7bit address: 0x4A
 */

#ifndef MAX44005_H
#define MAX44005_H

#include "mbed.h"

class MAX44005
{
public:
 /**
 * MAX44005 constructor
 *
 * @param sda SDA pin
 * @param scl SCL pin
 * @param addr address of the I2C peripheral
 */
 MAX44005(PinName sda, PinName scl, int addr) ;
 
 ~MAX44005() ;

 /*
  * some member functions here (yet to be written)
  */
 int16_t getAMB_CLEAR(void) ;
 int16_t getAMB_RED(void) ;
 int16_t getAMB_GREEN(void) ;
 int16_t getAMB_BLUE(void) ;
 int16_t getIR(void) ;
 int16_t getIRCOMP(void) ;
 int16_t getTEMP(void) ;
 void    enableTEMP(void) ;
 void    disableTEMP(void) ;
 void    enableAMBINT(void) ;
 void    disableAMBINT(void) ;
 void    enablePRXINT(void) ;
 void    disablePRXINT(void) ;
 void    setMode(uint8_t newMode) ;
 
private:
  I2C m_i2c;
  int m_addr;
  void readRegs(int addr, uint8_t *data, int len) ;
  void writeRegs(uint8_t *data, int len) ;
} ;
#endif /* MAX44005_H */