/*
 * File description here
 */
#include "MAX44000.h"

/* some definitions here */
#define REG_INT_STATUS  0x00
#define REG_MAIN_CONFIG 0x01
#define REG_RECV_CONFIG 0x02
#define REG_TRNS_CONFIG 0x03

/* ADC DATA */
#define REG_ADC_MSB    0x04
#define REG_ADC_LSB    0x05
#define REG_ADC_BYTE   0x16

/* THRESHOLD SET */
#define REG_ALS_UMSB   0x06
#define REG_ALS_ULSB   0x07
#define REG_ALS_LMSB   0x08
#define REG_ALS_LLSB   0x09
#define REG_THR_PT     0x0A
#define REG_PRXTHR_IND 0x0B
#define REG_PRX_THR    0x0C
#define REG_TRM_GAING  0x0F
#define REG_TRM_GAINIR 0x10
    
MAX44000::MAX44000(PinName sda, PinName scl, int addr) : m_i2c(sda, scl), m_addr(addr<<1) {
    // activate the peripheral
    uint8_t conf = 0 ;
    conf = \
          0x20 /* Use factory-programmed gains for green and IR channels. */
        | 0x10 /* ALS and PROX are interleaved ontinuously. */
        ;
    setMainConfig(conf) ;
}

MAX44000::~MAX44000() { }

void MAX44000::readRegs(int addr, uint8_t * data, int len) {
    char t[1] = {addr} ;
    m_i2c.write(m_addr, t, 1, true) ;
    m_i2c.read(m_addr, (char*)data, len) ;
}

void MAX44000::writeRegs(uint8_t * data, int len) {
   m_i2c.write(m_addr, (char *)data, len) ;
}

void MAX44000::getIntStatus(uint8_t *data)
{
    readRegs(REG_INT_STATUS, data, 1) ;
}

void MAX44000::getMainConfig(uint8_t *conf)
{
    readRegs(REG_MAIN_CONFIG, conf, 1) ;
}

void MAX44000::setMainConfig(uint8_t newConf)
{
    uint8_t data[2] ;
    data[0] = REG_MAIN_CONFIG ;
    data[1] = newConf ;
    writeRegs(data, 2) ;
}

void MAX44000::getRxConfig(uint8_t *conf)
{
    readRegs(REG_RECV_CONFIG, conf, 1) ;
}

void MAX44000::setRxConfig(uint8_t newConf)
{
    uint8_t data[2] ;
    data[0] = REG_RECV_CONFIG ;
    data[1] = newConf ;
    writeRegs(data, 2) ;    
}

void MAX44000::getTxConfig(uint8_t *conf)
{
    readRegs(REG_TRNS_CONFIG, conf, 1) ;
}

void MAX44000::setTxConfig(uint8_t newConf)
{
    uint8_t data[2] ;
    data[0] = REG_TRNS_CONFIG ;
    data[1] = newConf ;
    writeRegs(data, 2) ;    
}   

void MAX44000::getALS(uint8_t *ofl, uint16_t *value) 
{
    uint8_t data[2] ;
//    readRegs(REG_ADC_MSB, data, 2) ;
    readRegs(REG_ADC_MSB, data, 1) ;
    readRegs(REG_ADC_LSB, &data[1], 1) ;
    *value = ((data[0] & 0x3F)<<8) | data[1] ;
    *ofl = (data[0] >> 6) & 0x01 ; // overflow
}

void MAX44000::getProx(uint8_t *value) 
{
    readRegs(REG_ADC_BYTE, value, 1) ;
}

void MAX44000::getADC(uint8_t *ofl, uint16_t *als, uint8_t *prox)
{
    getALS(ofl, als) ;
    getProx(prox) ;
}

void MAX44000::getUPTHR(uint16_t *thr)
{
    readRegs(REG_ALS_UMSB, (uint8_t*)thr, 2) ;
    *thr &= 0x3FFF ;
}

void MAX44000::setUPTHR(uint16_t newThr)
{
    uint8_t data[3] ;
    data[0] = REG_ALS_UMSB ;
    data[1] = (newThr >> 8) & 0x3F ;
    data[2] = (newThr & 0xFF) ;
    writeRegs(data, 3) ;
}

void MAX44000::getLOTHR(uint16_t *thr)
{
    readRegs(REG_ALS_LMSB, (uint8_t*)thr, 2) ;
    *thr &= 0x3FFF ;
}

void MAX44000::setLOTHR(uint16_t newThr)
{
    uint8_t data[3] ;
    data[0] = REG_ALS_LMSB ;
    data[1] = (newThr >> 8) & 0x3F ;
    data[2] = (newThr & 0xFF) ;
    writeRegs(data, 3) ;
}

void MAX44000::getTHRPT(uint8_t *data)
{
    readRegs(REG_THR_PT, data, 1) ;
}

void MAX44000::setTHRPT(uint8_t newData)
{
    uint8_t data[2] ;
    data[0] = REG_THR_PT ;
    data[1] = newData ;
    writeRegs(data, 2) ;
}

void MAX44000::getPRXTHR_IND(uint8_t *value)
{
    uint8_t data ;
    readRegs(REG_PRXTHR_IND, &data, 1) ;
    *value = (data >> 6) & 0x01 ;
}

void MAX44000::setPRXTHR_IND(uint8_t newValue)
{
    uint8_t data[2] ;
    data[0] = REG_PRXTHR_IND ;
    data[1] = (newValue & 0x01) << 6 ;
    writeRegs(data, 2) ;
}

void MAX44000::getPRX_THR(uint8_t *data)
{
    readRegs(REG_PRX_THR, data, 1) ;
}

void MAX44000::setPRX_THR(uint8_t newValue)
{
    uint8_t data[2] ;
    data[0] = REG_PRX_THR ;
    data[1] = newValue ;
    writeRegs(data, 2) ;
}

void MAX44000::getTRM_GAING(uint8_t *data)
{
    readRegs(REG_TRM_GAING, data, 1) ;
}

void MAX44000::setTRM_GAING(uint8_t newValue)
{
    uint8_t data[2] ;
    data[0] = REG_TRM_GAING ;
    data[1] = newValue ;
    writeRegs(data, 2) ;
}

void MAX44000::getTRM_GAINIR(uint8_t *data)
{
    readRegs(REG_TRM_GAINIR, data, 1) ;
}

void MAX44000::setTRM_GAINIR(uint8_t newValue)
{
    uint8_t data[2] ;
    data[0] = REG_TRM_GAINIR ;
    data[1] = newValue ;
    writeRegs(data, 2) ;
}
