/**
 * Xtrinsic MAG3110 Three-Axis,
 * Digital Magnetometer
 */

#ifndef _MAG3110_H_
#define _MAG3110_H_

#include "mbed.h"

/**
 *
 */

class MAG3110
{
public:
 /**
 * MAG3110 constructor
 *
 * @param sda SDA pin
 * @param scl SCL pin
 * @param addr 7bit address of the I2C peripheral
 */
 MAG3110(PinName sda, PinName scl, int addr) ;
 
 ~MAG3110() ;

 /*
  * some member functions here (yet to be written)
  */
 void    standby() ;
 void    activate() ;
 uint8_t getStatus() ;
 int16_t getX() ;
 int16_t getY() ;
 int16_t getZ() ;
 uint8_t getID() ;
 int16_t getOffsetX() ;
 int16_t getOffsetY() ;
 int16_t getOffsetZ() ;
 void    setOffsetX(int16_t newOffset) ;
 void    setOffsetY(int16_t newOffset) ;
 void    setOffsetZ(int16_t newOffset) ;
 uint8_t getCtrlReg1() ;
 uint8_t getCtrlReg2() ;
 void    setCtrlReg1(uint8_t newValue) ;
 void    setCtrlReg2(uint8_t newValue) ;
 uint8_t  getTemp() ;

private:
  I2C m_i2c;
  int m_addr;
  void readRegs(int addr, uint8_t *data, int len) ;
  void writeRegs(uint8_t *data, int len) ;
} ;
#endif /* _MAG3110_H_ */