/*
 * File description here
 */
#include "MAG3110.h"

/* some definitions here */

/* value registers */
#define MAG_DR_STATUS 0x01
#define MAG_OUT_X     0x02
#define MAG_OUT_Y     0x04
#define MAG_OUT_Z     0x06
#define MAG_WHO_AM_I  0x07
#define MAG_SYSMOD    0x08
#define MAG_OFF_X     0x09
#define MAG_OFF_Y     0x0B
#define MAG_OFF_Z     0x0D
#define MAG_DIE_TEMP  0x0F
#define MAG_CTRL_REG1 0x10
#define MAG_CTRL_REG2 0x11

    
MAG3110::MAG3110(PinName sda, PinName scl, int addr) : m_i2c(sda, scl), m_addr(addr<<1) {
    // activate the peripheral
    activate() ;
}

MAG3110::~MAG3110() { }

void MAG3110::readRegs(int addr, uint8_t * data, int len) {
    char t[1] = {addr} ;
    m_i2c.write(m_addr, t, 1, true) ;
    m_i2c.read(m_addr, (char*)data, len) ;
}

void MAG3110::writeRegs(uint8_t * data, int len) {
   m_i2c.write(m_addr, (char *)data, len) ;
}

void MAG3110::standby(void)
{
    uint8_t res[2] ;
    res[0] = MAG_CTRL_REG1 ;
    readRegs(MAG_CTRL_REG1, &res[1], 1) ;
    res[1] &= 0xFE ; 
    writeRegs(res, 2) ;
}

void MAG3110::activate(void)
{
    uint8_t res[2] ;
    // measurements with ODR = 80 Hz, OSR = 1
    res[0] = MAG_CTRL_REG1 ;
    res[1] = 0x00 ; // standby!
    writeRegs(res, 2) ;
    
    res[0] = MAG_CTRL_REG2 ;
    res[1] = 0x80 ; // AUTO_MRST_EN
    writeRegs(res, 2) ;

    res[0] = MAG_CTRL_REG1 ;
    res[1] = 0x01 ; // activate!
    writeRegs(res, 2) ;
}

uint8_t MAG3110::getStatus() {
    uint8_t res[1] ;
    readRegs(MAG_DR_STATUS, res, 1) ;
    return( res[0] ) ;
}

int16_t MAG3110::getX() {
    int16_t value;
    uint8_t res[2];
    readRegs(MAG_OUT_X, res, 2) ;
    value = (res[0] << 8)+res[1] ;
    return( value ) ;
}

int16_t MAG3110::getY() {
    int16_t value;
    uint8_t res[2];
    readRegs(MAG_OUT_Y, res, 2) ;
    value = (res[0] << 8)+res[1] ;
    return( value ) ;
}

int16_t MAG3110::getZ() {
    int16_t value;
    uint8_t res[2];
    readRegs(MAG_OUT_Z, res, 2) ;
    value = (res[0] << 8)+res[1] ;
    return( value ) ;
}

uint8_t MAG3110::getID() {
    uint8_t res[1] ;
    readRegs(MAG_WHO_AM_I, res, 1) ;
    return( res[0] ) ;
}

int16_t MAG3110::getOffsetX() {
    int16_t value;
    uint8_t res[2];
    readRegs(MAG_OUT_X, res, 2) ;
    value = (res[0] << 8)+res[1] ;
    return( value ) ;
}

int16_t MAG3110::getOffsetY() {
    int16_t value;
    uint8_t res[2];
    readRegs(MAG_OUT_Y, res, 2) ;
    value = (res[0] << 8)+res[1] ;
    return( value ) ;
}

int16_t MAG3110::getOffsetZ() {
    int16_t value;
    uint8_t res[2];
    readRegs(MAG_OUT_Z, res, 2) ;
    value = (res[0] << 8)+res[1] ;
    return( value ) ;
}

void MAG3110::setOffsetX(int16_t newOffset) 
{
    uint8_t res[3] ;
    res[0] = MAG_OFF_X ;
    res[1] = (newOffset >> 8)&0xFF ;
    res[2] = newOffset & 0xFF ;
    writeRegs(res, 3) ;
}

void MAG3110::setOffsetY(int16_t newOffset) 
{
    uint8_t res[3] ;
    res[0] = MAG_OFF_Y ;
    res[1] = (newOffset >> 8)&0xFF ;
    res[2] = newOffset & 0xFF ;
    writeRegs(res, 3) ;
}

void MAG3110::setOffsetZ(int16_t newOffset) 
{
    uint8_t res[3] ;
    res[0] = MAG_OFF_Z ;
    res[1] = (newOffset >> 8)&0xFF ;
    res[2] = newOffset & 0xFF ;
    writeRegs(res, 3) ;
}

uint8_t MAG3110::getCtrlReg1() 
{
    uint8_t res[1];
    readRegs(MAG_CTRL_REG1, res, 1) ;
    return( res[0] ) ;
}

uint8_t MAG3110::getCtrlReg2()
{
    uint8_t res[1];
    readRegs(MAG_CTRL_REG2, res, 1) ;
    return( res[0] ) ;
}
 
void    MAG3110::setCtrlReg1(uint8_t newValue)
{
    uint8_t res[2] ;
    res[0] = MAG_CTRL_REG1 ;
    res[1] = newValue ;
    writeRegs(res, 2) ;
}
 
void    MAG3110::setCtrlReg2(uint8_t newValue)
{
    uint8_t res[2] ;
    res[0] = MAG_CTRL_REG2 ;
    res[1] = newValue ;
    writeRegs(res, 2) ;
}

uint8_t  MAG3110::getTemp(void) 
{
    uint8_t temp[1] ;
    int8_t value ;
    readRegs(MAG_DIE_TEMP, temp, 1) ;
    /*
    if (temp[0] & 0x80) { // negative 
        value = -(~(temp[0])+1) ;
    } else {
        value = temp[0] ;
    }
    return(value) ;
    */
    return(temp[0]) ;
}
