/* Copyright (c) 2010-2011 mbed.org, MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include "HIH6130.h"

HIH6130::HIH6130(PinName sda, PinName scl, int addr) : m_i2c(sda, scl), m_addr(addr<<1) {
    // activate the peripheral
}

HIH6130::~HIH6130() { }

void HIH6130::measure(void)
{
    m_i2c.start() ;
    m_i2c.write(m_addr) ;
    m_i2c.stop() ;
}

/**
 * start Command Mode
 *
 * @param none
 * @returns none
 *
 * @note this must be called within 3ms or 10ms 
 * @note after Power On
 */
void HIH6130::start_CM(void)
{
    uint8_t data[3] = { 0xA0, 0x00, 0x00 } ;
    m_i2c.write(m_addr, (char *)data, 3);
}

/**
 * Ends Command Mode and enter Normal Operation Mode
 *
 * @param none
 * @returns none
 *
 * @note only valid in Command Mode
 */
void HIH6130::start_NOM(void)
{
    uint8_t data[3] = { 0x80, 0x00, 0x00 } ;
    m_i2c.write(m_addr, (char *)data, 3);
}

uint16_t HIH6130::getValue(float *humidity, float *temperature)
{
    uint16_t status = 0 ;
    uint8_t data[4] ;
    data[0] = 0x00 ;
    readRegs(0, data, 4) ;

    status = (data[0] >> 6) & 0x03 ;
    *humidity = (float)((data[0] & 0x3F) * 256 + data[1]) * 100.0 / (float)0x3FFF ;
    *temperature = (float)((data[2] * 64) + (data[3] >> 2)) * 165.0 / (float)0x3FFF - 40.0 ;
    return( status ) ;
}

void HIH6130::readRegs(int addr, uint8_t * data, int len) {
    char t[1] = {addr};
    m_i2c.write(m_addr, t, 1, true);
    m_i2c.read(m_addr, (char *)data, len);
}

void HIH6130::writeRegs(uint8_t * data, int len) {
    m_i2c.write(m_addr, (char *)data, len);
}
