/**
 * FXOS8700CQ  
 * 6-Axis Sensor with Intergrated Linear Accelerometer and Magnetometer
 */
#ifndef _FXOS8700CQ_H_
#define _FXOS8700CQ_H_

/**
 * 
 *
 */

class FXOS8700CQ
{
public:
 /**
  * FXOS8700CQ
  *
  * @param sda SDA pin
  * @param scl SCL pin
  * @param addr 7bit address of the I2C peripheral
  * I2C address
  * 0x1E (SA1 = 0, SA0 = 0)
  * 0x1D (SA1 = 0, SA0 = 1)
  * 0x1C (SA1 = 1, SA0 = 0)
  * 0x1F (SA1 = 1, SA1 = 1)
  */
FXOS8700CQ(PinName sda, PinName scl, int addr) ;

~FXOS8700CQ() ;

void standby(void) ;
void activate(void) ;
void init(void) ;

void readAccMgnData(int16_t *accData, int16_t *mgnData) ;

private:
  I2C m_i2c;
  int m_addr ;
  void readRegs(int addr, uint8_t *data, int len) ;
  void writeRegs(uint8_t *data, int len) ;
} ;

#endif /* _FXOS8700CQ_H_ */