#ifndef _DS1683_H_
#define _DS1683_H_

/**
 * Maxim DS1683 Total-Elasped-Time and Event Recorder with Alarm 
 *
 * @code
 * // write sample code here //
 * @endcode
 */
 
class DS1683 
{
public:
/**
 * DS1683 constructor
 *
 * @param sda SDA pin
 * @param sdl SCL pin
 * @param event EVENT pin (input)
 * @param alarm ALARM pin (output)
 * @param addr addr of the I2C peripheral
 */
DS1683(PinName sda, PinName scl, PinName event, PinName alarm, int addr);

/**
 * DS1683 destructor
 */
~DS1683() ;

/**
 * enter password
 *
 * @param pass unsigned long password value, initial value is 0xFFFFFFFF
 */
void     enterPW(uint32_t pass) ;
void     setCommand(uint8_t cmd) ;
uint8_t  getCommand(void) ;
void     setConfig(uint8_t conf) ;
uint8_t  getConfig(void) ;
uint8_t  getStatus(void) ;

void     clearAlarm(void) ;

void     setETCAlarm(uint32_t count) ;
uint32_t getETCAlarm(void) ;
void     setETC(uint32_t count) ;
uint32_t getETC(void) ;
void     clearETC(void) ;

void     setEventAlarm(uint16_t count) ;
uint16_t getEventAlarm(void) ;
void     setEventCount(uint16_t count) ;
uint16_t getEventCount(void) ;
void     clearEvent(void) ;

void     enableETCAlarm(void) ;
void     disableETCAlarm(void) ;
void     enableEventAlarm(void) ;
void     disableEventAlarm(void) ;
void     alarmPol(int pol) ;
void    clearRegs(void) ;
void    dumpRegs(void) ;
void    dumpETC(void) ;
void    dumpEvent(void) ;

int     write(int addr, uint8_t *data, int len) ;
int     read(int addr, uint8_t *data, int len) ;
uint8_t  readReg8(int addr) ;
void     writeReg8(int addr, uint8_t value) ;
uint16_t readReg16(int addr) ;
void     writeReg16(int addr, uint16_t value) ;
uint32_t readReg32(int addr) ;
void     writeReg32(int addr, uint32_t value) ;

DigitalOut event ;
InterruptIn alarm ;

private:
 I2C m_i2c ;
 int m_addr ;


int     readRegs(int addr, uint8_t * data, int len) ;
int     writeRegs(uint8_t * data, int len) ;

} ;
#endif /* _DS1683_H_ */