/*************************************
 * AK9753
 * AKM Ultra-small IR Sensor IC with I2C I/F
 **/
#ifndef _AK9753_H_
#define _AK9753_H_
#include "mbed.h"

class AK9753
{
public:
  /**
  * AK9753 constructor
  *
  * @param sda SDA pin
  * @param sdl SCL pin
  * @param addr addr of the I2C peripheral
  */
  AK9753(PinName sda, PinName scl, int addr);

  /**
  * AK9753 destructor
  */
  ~AK9753();
  
  uint8_t getCompanyCode(void) ;
  uint8_t getDeviceID(void) ;
  bool    dataReady(void) ; /* returns ST1[0], read ST2 to clear */
  bool    dataOverRun(void) ; /* return ST1[1], read ST2, etc, to clear */
  uint8_t getINTST(void) ; /** return REG_INTST */
  uint8_t getST1(void) ;
  int16_t getRawIR1(void) ;
  float   getIR1(void) ;
  int16_t getRawIR2(void) ;
  float   getIR2(void) ;
  int16_t getRawIR3(void) ;
  float   getIR3(void) ;
  int16_t getRawIR4(void) ;
  float   getIR4(void) ;
  int16_t getRawTMP(void) ;
  float   getTMP(void) ;
  uint8_t getST2(void) ;
  int16_t getETH13H(void) ;
  int16_t getETH13L(void) ;
  int16_t getETH24H(void) ;
  int16_t getETH24L(void) ;
  uint8_t getEHYS13(void) ;
  uint8_t getEHYS24(void) ;
  uint8_t getEINTEN(void) ;
  uint8_t getECNTL1(void) ;
  uint8_t getCNTL2(void) ;
  
  void    setETH13H(int16_t value) ;
  void    setETH13L(int16_t value) ;
  void    setETH24H(int16_t value) ;
  void    setETH24L(int16_t value) ;
  void    setEHYS13(uint8_t value) ;
  void    setEHYS24(uint8_t value) ;
  void    setEINTEN(uint8_t value) ;
  void    setECNTL1(uint8_t value) ;
  void    software_reset(void) ;
  

private:
  I2C m_i2c;
  int m_addr;
  int readRegs(int addr, uint8_t * data, int len);
  int writeRegs(uint8_t * data, int len);
};

#endif /* _AK9752_H_ */