/*************************************
 * AK9752
 * AKM Ultra-small IR Sensor IC with I2C I/F
 **/
#ifndef _AK9752_H_
#define _AK9752_H_
#include "mbed.h"

class AK9752
{
public:
  /**
  * AK9752 constructor
  *
  * @param sda SDA pin
  * @param sdl SCL pin
  * @param addr addr of the I2C peripheral
  */
  AK9752(PinName sda, PinName scl, int addr);

  /**
  * AK9752 destructor
  */
  ~AK9752();
  
  uint8_t getCompanyCode(void) ; /* 0x48 expected */
  uint8_t getDeviceID(void) ;    /* 0x14 expected */
  bool    dataReady(void) ; /* returns ST1[0], read ST2 to clear */
  uint8_t getIntcause(void) ; /* get REG_INTCAUSE (0x05) */
  int16_t getRawIR(void) ; /* raw data, must be mulitplied by 0.4578 for pA */
  float   getIR(void) ;
  int16_t getRawTMP(void) ; /* raw data, must be multiplied by 0.0019837 and + 25 */
  float   getTMP(void) ;
  bool    dataOverRun(void) ; /* check data over run and clear data ready */
  void    getTHIR(int16_t  *high, int16_t *low) ;
  void    setTHIR(int16_t   high, int16_t  low) ;
  void    getTHTMP(int16_t *high, int16_t *low) ;
  void    setTHTMP(int16_t  high, int16_t  low) ;
  uint8_t getINTEN(void) ;
  void    setINTEN(uint8_t value) ;
  uint8_t getCNTL1(void) ;
  void    setCNTL1(uint8_t value) ;
  uint8_t getCNTL2(void) ;
  void    setCNTL2(uint8_t value) ;
  void    software_reset(void) ;

private:
  I2C m_i2c;
  int m_addr;
  int readRegs(int addr, uint8_t * data, int len);
  int writeRegs(uint8_t * data, int len);
};

#endif /* _AK9752_H_ */