#ifndef _AK09970N_H_
#define _AK09970N_H_
/** 
 * AK09970N
 * 3D Magnetic Sensor with Programmable Switch
 */
#include "mbed.h"
class AK09970N
{
public:
  /**
  * AK09970N constructor
  *
  * @param sda SDA pin
  * @param sdl SCL pin
  * @param addr addr of the I2C peripheral
  */
  AK09970N(PinName sda, PinName scl, int addr);

  /**
  * AK09970N destructor
  */
  ~AK09970N();
  int       software_reset(void) ;
  int       getID(uint16_t *CompanyID, uint16_t *DeviceID) ;
  uint16_t  getStatus(void) ;
  int       setINT(uint16_t value) ;
  uint16_t  getINT(void) ;
  int       setConfig(uint8_t config) ;
  uint8_t   getConfig(void) ;
  int       singleShot(void) ;
  float     i2f(int16_t value) ; 

/* get data float version */
  int       getX(uint16_t *status, float *x) ;
  int       getY(uint16_t *status, float *y) ;
  int       getZ(uint16_t *status, float *z) ;
  int       getX_Y(uint16_t *status, float *x, float *y) ;
  int       getX_Z(uint16_t *status, float *x, float *z) ;
  int       getY_Z(uint16_t *status, float *y, float *z) ;
  int       getX_Y_Z(uint16_t *status, float *x, float *y, float *z) ;
  
/* get data 16bit version */
  int       getHX(uint16_t *status, int16_t *x) ;
  int       getHY(uint16_t *status, int16_t *y) ;
  int       getHZ(uint16_t *status, int16_t *z) ;
  int       getHX_HY(uint16_t *status, int16_t *x, int16_t *y) ;
  int       getHX_HZ(uint16_t *status, int16_t *x, int16_t *z) ;
  int       getHY_HZ(uint16_t *status, int16_t *y, int16_t *z) ;
  int       getHX_HY_HZ(uint16_t *status, int16_t *x, int16_t *y, int16_t *z) ;
    
/* get data 8bit version */
  int       getBX(uint16_t *status, int8_t *x) ;
  int       getBY(uint16_t *status, int8_t *y) ;
  int       getBZ(uint16_t *status, int8_t *z) ;
  int       getBX_BY(uint16_t *status, int8_t *x, int8_t *y) ;
  int       getBX_BZ(uint16_t *status, int8_t *x, int8_t *z) ;
  int       getBY_BZ(uint16_t *status, int8_t *y, int8_t *z) ;
  int       getBX_BY_BZ(uint16_t *status, int8_t *x, int8_t *y, int8_t *z) ;
  
/* get thresholds */
  int       getTHS_X1(int16_t *bop, int16_t *brp) ;
  int       getTHS_X2(int16_t *bop, int16_t *brp) ;
  int       getTHS_Y1(int16_t *bop, int16_t *brp) ;
  int       getTHS_Y2(int16_t *bop, int16_t *brp) ;
  int       getTHS_Z1(int16_t *bop, int16_t *brp) ;
  int       getTHS_Z2(int16_t *bop, int16_t *brp) ;  

/* set thresholds */
  int       setTHS_X1(int16_t bop, int16_t brp) ;
  int       setTHS_X2(int16_t bop, int16_t brp) ;
  int       setTHS_Y1(int16_t bop, int16_t brp) ;
  int       setTHS_Y2(int16_t bop, int16_t brp) ;
  int       setTHS_Z1(int16_t bop, int16_t brp) ;
  int       setTHS_Z2(int16_t bop, int16_t brp) ;  
  
private:
  uint8_t _mode ;
  uint8_t _sdr ;
  uint8_t _smr ;
  I2C m_i2c;
  int m_addr;
  int readRegs(int addr, uint8_t * data, int len);
  int writeRegs(uint8_t * data, int len);
};
#endif