// Some functions use the serial monitor so define it here.
Serial pc(USBTX,USBRX);

// The patient_record structure stores name and vitals for a patient.
struct patient_record {
    char firstname[30];
    char lastname[30];
    int systolic;
    int diastolic;
    float spO2;
};

// It is assumed that we will have an array of these patient records.
// We define the maximum number of patients that we will support.
#define MAX_PATIENTS 100

//Print the values in the structure for a particular patient.
void print_patient_record(struct patient_record *first_patient, int N) {
    pc.printf("%s %s \t ID: %d\n",first_patient[N].firstname, first_patient[N].lastname,N);
    pc.printf("BP: %d/%d  SpO2: %f\n",first_patient[N].systolic, first_patient[N].diastolic, first_patient[N].spO2);
}   

//Put patient into record.
void newPatient(struct patient_record *patient,  char *first, char*last)
{
    // We can't just set the firstname pointer equal to the
    // first pointer; that doesn't actually move the information into
    // the structure.  We need to copy each letter of the patient's name
    // into the structure.  strcpy does this.
    strcpy(patient->firstname, first);
    strcpy(patient->lastname,last);
}

//Fill in vital signs directly.  Note that we use -> when we have a
//pointer to a struct and we want to access one of the members.
void recordBP(struct patient_record *patient, int sys, int dias, float o2) {
    patient->systolic=sys;
    patient->diastolic=dias;
    patient->spO2 = o2;
}

//Fill in vital signs through the serial monitor (for BP) and the oxygen sensor,
//assumed to be an analog input giving the SpO2 level as a fraction.
void recordBPinteractive(struct patient_record *first_patient, AnalogIn oxygen) {
    int N;
    int s;
    int d;
    
    pc.printf("Enter the patient number:\n");
    pc.scanf("%d",&N);
    pc.printf("Enter the systolic BP:\n");
    pc.scanf("%d",&s);
    pc.printf("Enter the diastolic BP:\n");
    pc.scanf("%d",&d);
    
    //Note that [N] turns first_patient into a struct rather than a
    //pointer to a struct (dereferences the pointer).  Therefore, we
    //use . to access members.
    first_patient[N].systolic=s;
    first_patient[N].diastolic=d;
    first_patient[N].spO2=oxygen;
    
    //Print information to confirm
    pc.printf("Data entered:\n");
    print_patient_record(first_patient,N);
}      

//Look up the patient number by searching through the array of patients
//and matching the first and last name.  strcmp returns 0 if two strings
//are identical.  Return the patient's position in the array if name is
//found, -1 if it is not found.
int lookup_patient_name(struct patient_record *first_patient,char*first,char*last)
{
    for(int k=0; k<MAX_PATIENTS; k++) {
        if(strcmp(first_patient[k].lastname,last) == 0) {
            if(strcmp(first_patient[k].firstname,first) == 0) {
                return k;
            }
        }
    }
    return -1;
}

