#include "mbed.h"
#include "patients.h"

//Pretend we have a pulse oximeter attached to A0 which provides the SpO2
//as a fraction.
AnalogIn pulse_oximeter(A0);

int main()
{
    // Create an array of patient_record structures to form the patient database.
    struct patient_record all_patients[MAX_PATIENTS];
    // Keep track of the number of patients.
    int enrollment=0;
    
    //Add patient info.
    newPatient(&(all_patients[enrollment]),"George","Washington");
    enrollment++;

    newPatient(&(all_patients[enrollment]),"John","Adams");
    enrollment++;
    
    newPatient(&(all_patients[enrollment]),"Thomas","Jefferson");
    enrollment++;

    //Look up a patient--this one is not in our database.    
    int X=lookup_patient_name(all_patients,"Abraham","Lincoln");
    pc.printf("Abraham Lincoln is patient %d\n",X);
    
    //Look up a patient.    
    int Y=lookup_patient_name(all_patients,"Thomas","Jefferson");
    pc.printf("Thomas Jefferson is patient %d\n",Y);
   
    //Enter patient's vitals.
    recordBPinteractive(all_patients, pulse_oximeter);

    while(1);   


}