/*
  Switch statement
 
 Demonstrates the use of a switch statement.  The switch
 statement allows you to choose from among a set of discrete values
 of a variable.  It's like a series of if statements.
 
 To see this sketch in action, but the board and sensor in a well-lit
 room, open the serial monitor, and and move your hand gradually
 down over the sensor.
 
 The circuit:
 * photoresistor from analog in 0 to +3.3V
 * 10K resistor from analog in 0 to ground
 
 created 1 Jul 2009
 modified 9 Apr 2012
 by Tom Igoe 
 
 modified for Nucleo / mbed 12 Aug 2017
 by Sheila Ross
 
 This example code is in the public domain.
 
 http://www.arduino.cc/en/Tutorial/SwitchCase
 */


#include "mbed.h"

// Define the analog input we are using for the sensor
AnalogIn sensorVoltage(A0);

// Create a serial connection over our USB
Serial pc(USBTX, USBRX);

int main() {
  
    pc.baud(9600);  // Set serial communication speed

    while(1) {

        // Read the analog sensor
        // Rescale the reading to obtain a number between 0 and 3.999
        // which will be stored as 0 through 3 in the integer range
        
        int range = sensorVoltage*4;

        // do something different depending on the
        // range value:
        
        switch (range) {
        
            case 0:    // sensor is covered
        
                pc.printf("dark\n");
                break;
        
            case 1:    // sensor in dim light
        
                pc.printf("dim\n");
                break;
        
            case 2:    // sensor in medium light
        
                pc.printf("medium\n");
                break;
        
            case 3:    // bright light shining on sensor
         
                pc.printf("bright\n");
                break;
                
            default:   // error situation
            
                pc.printf("error\n");

        }
        
        wait(0.5);        // delay in between reads for stability

    }
}




