/* WhatTime

Uses a timer to print the time between button presses.

Created 12 Aug 2017 by Sheila Ross

*/

#include "mbed.h"
 
// Declare USER_BUTTON to be a digital input
DigitalIn mybutton(USER_BUTTON);

// Declare timer object
Timer mytimer;

// Create a serial connection over our USB
Serial pc(USBTX, USBRX);


int main()
{
    pc.baud(9600);
    
    mytimer.start();  // start the timer

    while(1) {

        if (mybutton == 0) { // Button is pressed
        
            // save the time on timer
            
            float current_time = mytimer.read();
                     
            // print the time
            
            pc.printf("Time difference %f seconds\n",current_time );
            
             // reset the timer
            
            mytimer.reset();
                     
            // wait for the user to release the button
            
            while(mybutton == 0) {
            }
        }
    }
}
 