#include "mbed.h"

/*  This program demonstrates the necessity of the volatile qualifier
on variables that are shared between main and interrupt servicing functions.

The purpose of the program is to record a timestamp in an array, each
time the user presses the button.  After 20 presses, all of the array
values are printed.

Note the global variable count with the volatile qualifier.

As of 10/24/17, when mbed compiles the below program *without* the volatile
qualifier, it apparently chooses to store the value of count in a register
for fast access, rather than loading it from SRAM memory each time.  This
is a timesaving optimization.

However, in the background, the interrupt servicing function record_time
is changing the value of count in memory.  Since main is using its own local 
copy in a register, it doesn't know that count is being changed.  Hence,
it thinks that count is still zero and does not get past the while loop.

The volatile qualifier tells the compiler that this variable needs to be loaded 
from SRAM memory each time, since it could change without main "knowing" it.

*/

InterruptIn button(USER_BUTTON);
Serial pc(USBTX,USBRX);

Timer timer;

float times[20];

void record_time();

volatile int count=0;


int main() {
    
    pc.baud(9600);
    timer.start();
    button.fall(&record_time);
    
    while(count<20) {}
                
    for(int k=0; k<20; k++) {
        pc.printf("%d:  %f\n",k,times[k]);
    }
   
    
}

void record_time() {
    if(count<20) {
    times[count] = timer.read();
    count++;
    }
}
















        
        
        
        
        
        
        
        
        
        
        
        
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    














