#include "mbed.h"
/* This program has the Nucleo sending out the floating point value
on analog A0 over the serial connection.  After the user presses 
the button, a sample is sent every 0.25 seconds(approximately; use Timeout 
interrupt to make it more exact).

MATLAB can connect to Nucleo using the serial object defined in MATLAB.
Here is MATLAB code to receive 100 samples:

>> nucleo = serial('COM3','BaudRate',9600);     %(replace with your COM channel)
>> fopen(nucleo);
>> for k=1:100,M(k)=fscanf(nucleo,"%f");end
>> fclose(nucleo);
>> clear nucleo;

Now the matrix M has 100 samples sent by the Nucleo.
*/

AnalogIn analog_value(A0);     // sensor attached to A0

DigitalIn button(USER_BUTTON); // press button to start transmission,
                               // MATLAB times out if no data received in 10 sec
                               
DigitalOut led(LED1);          // LED indicates sampling is in progress

Serial matlab(USBTX,USBRX);    // Named the Serial matlab instead of pc just
                               // to remind us that this is not TeraTerm 
int main() {
    while(button==1);          // wait for button press
    led=1;                     // then turn on LED
    for(int k=0;k<100;k++) {   // send out 100 samples
        float x=analog_value;  // best to put reading in a variable first
        matlab.printf("%f\n",x);  // send out the reading
        wait(.25);             // wait .25 seconds
    }
    led=0;                     // turn off LED when done
    while(1);                  // stop forever   
}
