#include "mbed.h"
/*  MATLAB can send data over to the Nucleo to control its operation or
to output data via AnalogOut, etc.  In this case, MATLAB sends a number and the
onboard LED is set to blink that many times in 2 seconds.

MATLAB can connect to Nucleo using the serial object defined in MATLAB.
Here is MATLAB code to send number:

>> nucleo = serial('COM3','BaudRate',9600);     %(replace with your COM channel)
>> fopen(nucleo);
>> fprintf(nucleo,'5\n');  %This line can be repeated with values other than 5
>> fclose(nucleo);         %When you are all done, close connection
>> clear nucleo;                %Clear object from memory

*/
PwmOut light(LED1);
Serial matlab(USBTX,USBRX);
int main() {
    int x;
    light=0.5;  // turn on light
    while(1){
        matlab.scanf("%d",&x);  // get number from MATLAB
        light.period(2.0/x);    // set new period for blinking
    }
  
}
