#include "mbed.h"
 
DigitalOut green_led(LED1);
InterruptIn button(USER_BUTTON);
Timeout fivesec;
Serial pc(USBTX,USBRX);
Timer reaction_timer;

bool five_second_flag = false;

void handle_button_press();
void turn_on_green_light();

int main() {
    pc.baud(9600);
    pc.printf("Welcome to the reaction timer!\n");
    fivesec.attach(&turn_on_green_light,5);
    button.fall(&handle_button_press);

    while(1) {}
}

void turn_on_green_light() {
    green_led=1;
    reaction_timer.start();
    five_second_flag=true;
}

void handle_button_press() {
    if(five_second_flag==false) {
        pc.printf("Error! Too early\n");
    }
    else {
        switch(reaction_timer.read_ms()/200) {
            case 0:
                pc.printf("Fast!\n");
                break;
            case 1:
                pc.printf("Good.\n");
                break;
            case 2:
                pc.printf("Ok...\n");
                break;
            case 3:
                pc.printf("Slow\n");
                break;
            default:
                pc.printf("Are you awake?\n");
        }
    }    
     
    while(1) {}
}