/*
  For Loop Iteration
 
 Demonstrates the use of a for() loop. 
 Lights multiple LEDs in sequence, then in reverse.
 
 The circuit:
 * LEDs from pins 2 through 11 to ground
 
 created 2006
 by David A. Mellis
 modified 30 Aug 2011
 by Tom Igoe 

 modified for Nucleo / mbed 12 Aug 2017
 by Sheila Ross

This example code is in the public domain.
 
 http://www.arduino.cc/en/Tutorial/ForLoop
 */

#include "mbed.h"

float timer = 0.1;           // The higher the number, the slower the timing.

BusOut bar_graph(D2,D3,D4,D5,D6,D7,D8,D9,D10,D11);

int main() {
  
    while(1) {  // keep the lights going forever

        // light will shift from 0 places to 9 places

        for(int shift=0; shift<10; shift++) {

            // Output a 1 shifted over "shift" places

            bar_graph = (1<<shift);

            wait(timer);
        }

        // now do the same in reverse

        for(int shift=9; shift>=0; shift--) {

            bar_graph = (1<<shift);

            wait(timer);
        }

    }


  
}