#include "mbed.h"

// Declare that the USER_BUTTON will trigger an external interrupt mybutton
InterruptIn mybutton(USER_BUTTON);

DigitalOut myled(LED1);

// Function prototypes
void pressed();
void released();
  
int main()
{
    // Define the behavior of the interrupt on rising and falling edges
    mybutton.fall(&pressed);
    mybutton.rise(&released);
    
    // do nothing; the interrupt servicing functions do all the work
    while(1) {
        wait(1);
    }    
    
}

void pressed() {  // short flash when pressed
    myled = 1;
    wait(0.2);
    myled = 0;
}

void released() {  // long flash when released
    myled = 1;
    wait(1);
    myled = 0;
}
