/* thermistor.h

   Contains the definition for the Fahrenheit temperature calculation
   
   The input is the analog reading, and the returned float value is the
   temperature in degrees Fahrenheit.

*/

float temp_calc(float analog_value) {
        double R_ratio = (1/analog_value - 1);
        double logR_ratio=log(R_ratio);
        double T_kelvin=1/(.003354016+.000256985*logR_ratio+.000002620131*logR_ratio*logR_ratio);
        float T = 1.8*(T_kelvin - 273) + 32;
        return T;
}