/*  Audible Thermometer

Creates beeps of increasing pitch and pulse rate as the temperature
rises above the nominal value.

Hardware:   10k resistor from A0 to ground
            10k nominal thermistor from A0 to 3V3
            Speaker from D9 to ground

*/

#include "mbed.h"
#include "thermistor.h"   // This file contains the temperature calculation

#define  NOMINAL_TEMP  75  // Change the nominal temperature here

AnalogIn therm(A0);
PwmOut speaker(D9);
Serial pc(USBTX,USBRX);

// This function will be defined in this file, main.cpp
void beep(float freq, float duration);

int main()
{
    while(1) {
        
        // Calculate Temperature
        int tempF = temp_calc(therm);  // This function is in thermistor.h
        
        // Calculate difference from nominal
        int difference = tempF-NOMINAL_TEMP;
        
        // If I have a fever...
        if (difference >= 1) {
            
            // Create a warning beep that gets higher in pitch and
            // more rapid as temperature increases
            float frequency = difference*100;
            float duration = .5/difference;
            
            // Call beeping function defined below
            beep(frequency,duration);
            
            wait(duration);
        }
    }
}

void beep(float freq, float duration)   // Note that one of the variables
{                                       // in the note() function has the same
    speaker.period(1/freq);             // as a variable in main().
    speaker=.5;                         // That's ok, since they are local
    wait(duration);                     // to their respective functions.
    speaker=0;                          // This function also uses a global
}                                       // variable, speaker.

