#include "mbed.h"

/*
  Arrays
 
 Demonstrates the use of  an array to hold pin numbers
 in order to iterate over the pins in a sequence. 
 Lights multiple LEDs in non-contiguous sequence, then in reverse.
 
 The circuit:
 * LEDs from pins 2 through 11 to ground
 
 created 2006
 by David A. Mellis
 modified 30 Aug 2011
 by Tom Igoe 
 modified for Nucleo / mbed 12 Aug 2017
 by Sheila Ross

This example code is in the public domain.
 
 http://www.arduino.cc/en/Tutorial/Array
 */

float timer = 0.2;           // The higher the number, the slower the timing.
int position[] = {        // an array of pin numbers to which LEDs are attached   
  2, 7, 4, 6, 5, 3, 9, 1, 0, 8 };       
int pinCount = 10;         // the number of pins (i.e. the length of the array)

BusOut bar_graph(D2,D3,D4,D5,D6,D7,D8,D9,D10,D11);

int main() {
  
    while(1) {  // keep the lights going forever


        for(int n=0; n<pinCount; n++) {

            // Output a 1 shifted over "position" places
            // for the various values of "position"

            bar_graph = (1<<position[n]);

            wait(timer);
        }

        
    }

}