#include "mbed.h"

/*  This program creates two analog outputs:
    A staircase wave on A2
    Voltage representing light level on D13

    It is assumed that the photoresistor is connected to A0
    in the usual manner.
*/

AnalogIn light(A0);

// Our board only has two analog outputs, on A2 and D13.
AnalogOut my_output1(A2);
AnalogOut my_output2(D13);

// Levels for the staircase wave.
float wave_data[]= {0,.25,.5,.75,1,.75,.5,.25};

int length=8;

int main()  {
    
    while(1) {

        // Go through the array to output the voltage levels.
        // Also pass the light level out to D13 (my_output2).
        // Change the level every 1 ms.

        for(int k=0; k<length; k++) {
            my_output1 = wave_data[k];
            my_output2=light;
            wait_ms(1);
        }
    }
}
