#include "mbed.h"
#define zeitfaktor 1
#define tastendruck_kurz 100
#define tastendruck_lang 500
#define LED_frequenz 300

/*
 Beim Betaetigen des Blinkhebels eines Kraftfahrzeuges werden folgende Blinkzustaende erreicht: 1. Kurze Betaetigung des Blinkhebels – viermaliges Blinken in der gewaehlten Richtung (Blinker rechts bzw. links). Ohne weitere Aktion des Bedieners endet das Blinken automatisch.
 2. Lange Betaetigung des Blinkhebels – der Blinkvorgang dauert genauso lange wie der Blinkhebel betaetigt wird. Loslassen, bzw. Rueckstellen des Hebels fuehrt zum sofortigen Verloeschen des Blinkers.

 Realisieren Sie die oben beschriebene Funktionalitaet unter Nutzung der beiden Tasten BTN1 und BTN2 auf dem Testboard als Blinkertaste Links bzw. Rechts.
 Als Blinker werden die Leuchtdioden LED1 und LED4 auf dem Rechnermodul verwendet. Die Blinkzeiten betragen 300 ms Ein bzw. 300 ms Aus. Ein kurzer Tastendruck (<= 100 ms ) startet den Automatikmode (4 x Blinken, dann Aus). Der Automatikmode wird nach den vier Blinkzyklen beendet.
 Mit einem laengeren Tastendruck (>= 500 ms) wird dauerhaft Geblinkt. Beim los lassen der Taste wird das Blinken sofort gestoppt.

 */

DigitalOut LED_1(P1_18);
DigitalOut LED_2(P1_20);
//DigitalOut LED_3(P1_21);
//DigitalOut LED_4(P1_23);
DigitalIn BTN_1(p8);
DigitalIn BTN_2(p14);


int main()
{
    LED_1=0;
    LED_2=0;
    int kurz=0, lang=0;                   //binaer, differenziert zwichen "KURZ" und "LANGE" antippen des Blinkers
    int long BTN_count=0, LEDt_count=0;   //normale Zahl-groß, zaehlt bzw misst die Dauer des Tastendrucks_LED Dauer
    int LEDn_count=0;                     //normale Zahl<=3, zaehlt die Anzahl der blinkvorgaenge
    int BTN=0, LED=0, LEDn=0;        //Variablen reraesentieren innerhalb der Schleife die physichen digitalen Ein- und Ausgänge.

    /*
    * Insgesammt sollte innerhalb der gesammten Schleife keine weitere Schleife eröffnet werden welche auf externe Recourcen wie LEDs oder BTNs zurückgreift da diese nur zu Anfang und zu ende abgefragt bzw zugewiesen werden.
    * Alle Zeitzähler zählen immer ein vielfaches von wait(0.001). Es ist möglich die Polling-Zeit mit dem Makro am "zeitfaktor" (zu Anfang des Codes) aus debugging Gruenden zu steuern.
    */
    while(1) {

        //einer der Beiden Knöpfe wird abgefragt und der allgemeinen Variablen BTN zugeweisen
        //die dazu entsprechende LED wird vermerkt
        BTN=0;
        if(!BTN_2) {
            BTN=1;
            LEDn=1;
        } else {
            if(!BTN_1) {
                BTN=1;
                LEDn=2;
            }
        }

        //Zaehler fuer die Druckdauer des Knopfes (in durchlaeufen); initiieren von "KURZ"; zuruecksetzen des Zaehlers fuer die Drueckdauer im Fall des nicht mehr gedrueckten Knopfes
        if (BTN) {
            BTN_count++;
            kurz=1;
        } else {
            BTN_count=0;
            lang=0;
        }


        //umschalten zwischen "kurz"em druecken zu "lang"en druecken
        if (BTN_count>=tastendruck_lang) {
            kurz=0;
            lang=1;
        }

//--> BEGINN: Blinkvorgang und begrenzen der Blinkanzahl
//"KURZ": hier folgt der Ablauf fuer den kurzen Tastendruck
        /*
         es wird sowohl die Anzahl der Blinkvorgaenge als auch die Dauer des "LED=1" gezaehlt.
         Blinkte die LED 3 mal und es wurde nicht auf "LANG" umgeschlatet werden alle Variablen auf Anfang gesetzt.
         */
        if (kurz) {
            if ((LEDt_count % LED_frequenz)==0) { //LED ein und aus schalten
                LED=!LED;
                LEDn_count++;
            }
            LEDt_count++;
            if (LEDn_count>7) {//4 mahliges Blinken(entspricht 8 Falnken, auch wenn die 8te Flanke die LED quasi nochmal kurz an schlatet) setzt alle Zaehler zurueck und schaltet aus.
                kurz=0;
                LED=0;
                LEDt_count=0;
                LEDn_count=0;
            }
        } else {

//"LANGE": wird der Taster laenger gedrueckt wechselt der Blinker in das Statische blinken
            if (lang) {
                if ((LEDt_count % LED_frequenz)==0) { //LED ein und aus schalten
                    LED=!LED;
                    LEDn_count++;
                }
                LEDt_count++;
            }

//wenn nicht "kurz" dann aber "lang", und wenn dass nicht dann gar nichts: alles auf 0
            else {
                lang=0;
                LED=0;
                LEDn_count=0;
                LEDt_count=0;
            }
        }

//<-- ENDE

//Die Repraesentation der LED wir der zu dem gedrueckten Knopf entsprechenden physichen LED zugewiesen.
        if(LEDn==1)
            LED_1=LED;
        else
            LED_1=0;
        if(LEDn==2)
            LED_2=LED;
        else
            LED_2=0;

        wait_ms(1*zeitfaktor);
    }
}
