/**************************************************************************
 *  Name:        Stoppuhr
 *  Date  :      11.12.2012
 *  Author:
 *  Revision List:
  --------------------------------------------------------------------------
  Date     | Author          | Change
  --------------------------------------------------------------------------
           |                 |
  --------------------------------------------------------------------------
 **************************************************************************/
#include "mbed.h"
#include "cdef.h"
#include "TextLCD.h"
#include "Timer.h"
//#define test


DigitalIn   bLinks(p8);
InterruptIn bBtnLinks(p8);

Timer       timer;
Timer       timerSoLangeGedrueckt;
Ticker      stTick;
TextLCD     stLcd(p26, p25, p24, p23, p22, p20, p19, TextLCD::LCD20x4);

/* Konstantenvereinbarungen */
#define nTastShort   2           /* Entprellzyklen */
#define nTastLong   800           /* 0,5 Sekunden gedrückt halten */

enum {  enOff,                   /* Uhr ist aus */
        enRun,                   /* Zeitläuft */
        enStop                   /* Zeit steht */
     };

int binBtnCheck=0;

volatile byte bStandby; /*
* Description : Warteflag
*/

byte bTastTimerLi;/*
* Description : Entprellzähler Links
*/

byte bTastState;/*
* Description : Zustandsautomat "Taste"
*/

byte bLcdState; /*
* Description :
*/

float fStoppUhr; /*
* Description :
*/

void vTimerTick( void )
{
    bStandby = 1;
}



/* Funktion "Taste Links gedrückt" */
void vButtonLeShort( void )
{
}

/* Funktion "Taste Links lange gedrückt" */
void vButtonLeLong( void )
{
}

/* Funktion "Taste Links losgelassen" */
void vButtonLeFree( void )
{
}


/*******************************************
 * APP1 - Tastenabfrage
 *******************************************/
void vTasteLi( void )
{
}

/*******************************************
 * APP2 - LCD-Ausgabe
 *******************************************/
void vLcdOut( void )
{
}

void BtnUp()
{
    binBtnCheck=0;
    timerSoLangeGedrueckt.stop();
    timerSoLangeGedrueckt.reset();
}

void BtnDown()
{
    timerSoLangeGedrueckt.start();
}

/* Hauptprogramm */
int main()
{
    int binOnOff=0; //Switch für an-aus schalten der Stoippuhr
    bBtnLinks.rise(&BtnUp);
    bBtnLinks.fall(&BtnDown);
    byte i = 5;
    bStandby = 0;
    bLcdState = enOff;
    fStoppUhr = 0;
    stTick.attach_us(&vTimerTick, 20000);



    while(1) {

        if (timerSoLangeGedrueckt.read_ms()>=nTastLong) {
            timer.stop();
            timer.reset();
        }

        if (!binBtnCheck && !bLinks) { /* Knopf kurz drücken*/
            binBtnCheck=1;
#if define test
            stLcd.locate(0,0);
            stLcd.printf("Ich bin Stoppuhrr - was los!? ");
#endif
            

            if (binOnOff)
                timer.stop();
            else
                timer.start();

            binOnOff=!binOnOff; //umschalten zwichen an und aus
            stLcd.locate(0,1);
            //stLcd.printf("%d. mal",binOnOff, 20);

        }

        //-> ausgabe der aktuellen Zeit
        stLcd.locate(0,2);
        stLcd.printf("%.2lfs", timer.read());
        //<-

        while(bStandby == 0);
        bStandby = 0;
        vTasteLi();
        i--;
        if(i == 0) {
            i = 5;
            vLcdOut();
        }
    }
}
