#include "mbed.h"

DigitalOut LedOut(P1_18);
DigitalIn BtnIn1(p8);
DigitalIn BtnIn2(p14);
InterruptIn IrBtn1(p8);
InterruptIn IrBtn2(p14);
DigitalOut PeepOut(P2_5);

#define PEEP

int jetzt=0;                //schalter für alle 4 Sekunden
int BtnCheck=1;             //Sicherung gegen Umschalter an-aus

void BtnDown()
{
    jetzt=1;
}

void BtnUp()
{
    BtnCheck=1;
}

int main()
{
    IrBtn1.fall(&BtnDown);
    IrBtn2.fall(&BtnDown);
    IrBtn1.rise(&BtnUp);
    IrBtn2.rise(&BtnUp);

    int LedSw=0;                //Switch welches die LED aus schaltet und veraenderungen an der Helligkeitsvariablen verhindert
    int count=0;                //timer absolut
    int LedPwm=0, PeepPwm=0;               //timer 0 bis 100 fuer Led PWM
    int Btn1=0, Btn2=0, Led=0, Peep=0;  //Abgreifen der Physischen Eingaenge
    int hell=50, freq=700;                //Helligkeitsvariable
    

    while(1) {


//Auslesen der BTN Inputs
        Btn1 = !BtnIn1;
        Btn2 = !BtnIn2;

        /*
        * Switch
        * Led und Helliugkeits-steuerung An-Aus Schalter
        */
        if (Btn1 && Btn2 && BtnCheck) {
            BtnCheck= 0; //BtnCheck Variable muss in einem Interrupt BtnUp wieder auf 1 gesetzt werden!!!
            LedSw   = !LedSw;
        }

        /*
        * 4 Sekunden timer
        * Loest alle 4 Sekunden aus Um langsam die Helligkeitsstufen zu durchlaufen.
        */
        count++;
        jetzt = (count==20000); //jetzt Variable muss in einem Interrupt BtnDown wieder auf 1 gesetzt werden.
        count = count * !(jetzt);

        /*
        * Heller Dunkler
        * Veraenderung der Helligkeitsvariablen
        */
        hell = hell + (Btn2 && LedSw && jetzt && (hell<99));
        hell = hell - (Btn1 && LedSw && jetzt && (hell>=1));
//Hier folgt der frequenzveraenderer, leider noch nicht fertig
#ifdef PEEP
        freq = freq + (Btn2 && !LedSw && jetzt && (freq<1000));
        freq = freq - (Btn1 && !LedSw && jetzt && (freq>400));        
#endif        

        /*
        * PWM Timer
        * Timer von 0 bis 100 um die LED leuchten zu lassen.
        * Die Led ist nur an wenn sie nicht via LedSw aus geschaltet ist und die Helligkeitsvariable groesser dem PWM Timer ist.
        */
        LedPwm++;
        LedPwm = LedPwm * !(100==LedPwm);
        Led    = LedSw && (LedPwm<hell);
        
#ifdef PEEP        
        /*
        * Bullshit
        * hier folgt der Peeper und aller anderer Misst
        */
        PeepPwm++;
        PeepPwm = LedPwm * !(freq==LedPwm);
        Peep = !LedSw && (LedPwm<hell);
        PeepOut=Peep;
#endif
//zuweisen auf LED Output
        LedOut=Led;
 

        wait_us(1);

    }
}