#include "mbed.h"
#define t 0.5
#define tastendruck_kurz 100
#define LED_frequenz 300

/*
 Beim Betaetigen des Blinkhebels eines Kraftfahrzeuges werden folgende Blinkzustaende erreicht:  1. Kurze Betaetigung des Blinkhebels – viermaliges Blinken in der gewaehlten Richtung (Blinker rechts bzw. links). Ohne weitere Aktion des Bedieners endet das Blinken automatisch.
 2. Lange Betaetigung des Blinkhebels – der Blinkvorgang dauert genauso lange wie der Blinkhebel betaetigt wird. Loslassen, bzw. Rueckstellen des Hebels fuehrt zum sofortigen Verloeschen des Blinkers.
 
 Realisieren Sie die oben beschriebene Funktionalitaet unter Nutzung der beiden Tasten BTN1 und BTN2 auf dem Testboard als Blinkertaste Links bzw. Rechts.
 Als Blinker werden die Leuchtdioden LED1 und LED4 auf dem Rechnermodul verwendet. Die Blinkzeiten betragen 300 ms Ein bzw. 300 ms Aus.  Ein kurzer Tastendruck (<= 100 ms ) startet den Automatikmode (4 x Blinken, dann Aus). Der Automatikmode wird nach den vier Blinkzyklen beendet.
 Mit einem laengeren Tastendruck (>= 500 ms) wird dauerhaft Geblinkt. Beim los lassen der Taste wird das Blinken sofort gestoppt.
 
 */

DigitalOut LED(P1_18);
//DigitalOut LED_2(P1_20);
//DigitalOut LED_3(P1_21);
//DigitalOut LED_4(P1_23);
InterruptIn BTN(P0_6);
//InterruptIn BTN2(P0_16);


int main()
{
    
    //    event.fall(&change);
    int kurz=0, lang=0; //binaer, differenziert zwichen "KURZ" und "LANGE" antippen des Blinkers
    int BTN_count=0, LEDt_count=0; //normale Zahl-groß, zaehlt bzw misst die Dauer des Tastendrucks_LED Dauer
    int LEDn_count=0; //normale Zahl<=3, zaehlt die Anzahl der blinkvorgaenge
    
    
    while(1) {
        
        //Zaehler fuer die Druckdauer des Knopfes (in durchlaeufen); initiieren von "KURZ"; zuruecksetzen des Zaehlers fuer die Drueckdauer im Fall des nicht mehr gedrueckten Knopfes
        if (BTN) {
            BTN_count++;
            kurz=1;
        } else {
            BTN_count=0;
            lang=0;
        }
        
        
        //umschalten zwischen "kurz"em druecken zu "lang"en druecken
        if (BTN_count>=tastendruck_kurz) {
            kurz=0;
            lang=1;
        }
        
        
        //"KURZ": hier folgt der Ablauf fuer den kurzen Tastendruck
        /*
         es wird sowohl die Anzahl der Blinkvorgaenge als auch die Dauer des "LED=1" gezaehlt.
         Blinkte die LED 3 mal und es wurde nicht auf "LANG" umgeschlatet werden alle Variablen auf Anfang gesetzt.
         */
        if (kurz) {
            if ((LEDt_count % LED_frequenz)==0) { //LED ein und aus schalten
                LED=!LED;
                LEDn_count++;
            }
            LEDt_count++;
            if (LEDn_count>6) {//3 Maliges Blinken(6 Falnken, auch wenn die 6te Flanke die LED quasi nochmal kurz an schlatet) setzt alle Zaehler zurueck
                LED=0;
                LEDn_count=0;
                LEDn_count=0;
            }
        } else {
            
            //"LANGE": wird der Taster laenger gedrueckt wechselt der Blinker in das Statische blinken
            if (lang) {
                if ((LEDt_count % LED_frequenz)==0) { //LED ein und aus schalten
                    LED=!LED;
                    LEDn_count++;
                }
                LEDt_count++;
            }
            
            //wenn nicht "kurz" dann aber "lang", und wenn dass nicht dann gar nichts: alles auf 0
            else {
                LED=0;
                LEDn_count=0;
                LEDt_count=0;
            }
        }
        wait(0.001);
    }
    
}
