#include "mbed.h"
#include "TextLCD.h"
#include "eeprom.h"
#include <ctype.h>
#define tamvector 100
#define dato_v  6.2357e+03
#define dato_i  9.7128 //((3,3*2000/(2^16*Rburn))^2)*(1/100)
#define dato_p 202.6327
#define dato_e 0.02/3600000.0 //diferencia de tiempo entre muestras en segundos 
#define dato_pr 0,12143 // precio €/kWh
uint16_t VirtAddVarTab[NB_OF_VAR] = {0x5555, 0x6666, 0x7777};


Serial bluetooth (D10,D2);
Serial pc(SERIAL_TX,SERIAL_RX);
TextLCD lcd(D8,D9,D3,D4,D5,D6,TextLCD::LCD16x2); //rs,e,d4-d7
InterruptIn pulsador(PC_13);
float muestrasA[tamvector];
float muestrasB[tamvector];
float muestrasC[tamvector];
float muestrasD[tamvector];

AnalogIn tension (A0);
AnalogIn tensioncontinua (A1);
AnalogIn intensidad (A4);
AnalogIn intensidadcontinua (A5);
float Vcont;
float Icont;
int contador=0;
int contadorIntensidad=0;
int bufferlleno;
int nbuffer;
Ticker timerMuestro;
Ticker timerVisualizacion;
int i;
float Vrms;
float Irms;
float PotenciaActiva;
float PotenciaReactiva;
float PotenciaAparente;
float FactorPotencia;
float EnergiaActiva;
float EnergiaReactiva=0;
int mostrardato=0;
float precio;

void temporizador ()
{
    if(nbuffer) {
        muestrasA[contador]=(tension.read()-Vcont);
        muestrasC[contador]=(intensidad.read()-Icont);
    } else {
        muestrasB[contador]=(tension.read()-Vcont);
        muestrasD[contador]=(intensidad.read()-Icont);
    }
    contador++;
    if(contador==tamvector) {
        contador=0;
        nbuffer=!nbuffer;
        bufferlleno=1;
    }
}

void boton()
{
    mostrardato++;
    if (mostrardato>8)
        mostrardato=0;
}

void Write_Float_Eeprom(uint16_t address, float data) // parte de la memoria eeprom
{ 
    uint16_t *punteroDato;
    punteroDato=(uint16_t *)(&data);
    EE_WriteVariable(address  , *punteroDato);
    punteroDato++;
    EE_WriteVariable(address +2 , *punteroDato);
 
} 

float Read_Float_Eeprom(uint16_t address) // parte de la memoria eeprom
{ 

   float data; 
   uint16_t *punteroDato;
   punteroDato=(uint16_t *)(&data);
   EE_ReadVariable(address,punteroDato); 
   punteroDato++;
   EE_ReadVariable(address+2,punteroDato); 
   return data; 
} 

void mostrar ()
{
    lcd.cls();
    switch(mostrardato) {
        case 0:
            lcd.printf("Vrms:\n %f V",Vrms);
            pc.printf("Vrms:\n %f V",Vrms);
            break;
        case 1:
            lcd.printf("Irms:\n %f A",Irms);
            pc.printf("Irms:\n %f A",Irms);
            break;
        case 2:
            lcd.printf("F.pot:\n %f ",FactorPotencia);
            pc.printf("F.pot:\n %f ",FactorPotencia);
            break;
        case 3:
            
            lcd.printf("P.Act:\n %f W",PotenciaActiva);
            pc.printf("P.Act:\n %f W",PotenciaActiva);
            break;
        case 4:
            lcd.printf("P.React:\n %f VAr",PotenciaReactiva);
            pc.printf("P.React:\n %f VAr",PotenciaReactiva);
            break;
        case 5:
            lcd.printf("P.Apa:\n %f VA",PotenciaAparente);
            pc.printf("P.Apa:\n %f VA",PotenciaAparente);
            break;
        case 6:
            lcd.printf("E.Act:\n %f kWh",EnergiaActiva);
            pc.printf("E.Act:\n %f kWh",EnergiaActiva);
            break;
        case 7:
            lcd.printf("E.React:\n %f kWh",EnergiaReactiva);
            pc.printf("E.React:\n %f kWh",EnergiaReactiva);
            break;
        case 8:
            lcd.printf("Precio:\n %f ",precio);
            pc.printf("Precio:\n %f ",precio);
            break;
    }
    bluetooth.printf("%f | %f | %f | %f | %f \n",Vrms,Irms,PotenciaActiva,PotenciaReactiva,PotenciaAparente);
    Write_Float_Eeprom(0x5555, EnergiaActiva);   // parte de la memoria eeprom
    Write_Float_Eeprom(0x6666, EnergiaReactiva); // parte de la memoria eeprom
}

int main ()
{
    float suma;
    float sumapotenciaactiva=0;
    float sumaIntensidad;
    float dato;
    float datoIntensidad;


    HAL_FLASH_Unlock(); // parte de la memoria eeprom

    EE_Init();          // parte de la memoria eeprom

    timerMuestro.attach_us(&temporizador,200);
    timerVisualizacion.attach(&mostrar,1);
    pulsador.rise(&boton);
    Vcont=0;
    Icont=0;
    for (i=0; i<8; i++) {
        Vcont=Vcont+tensioncontinua.read();
        Icont=Icont+intensidadcontinua.read();
    }
    Vcont=Vcont/8.0;
    Icont=Icont/8.0; 

    EnergiaActiva=Read_Float_Eeprom(0x5555);    // parte de la memoria eeprom
    EnergiaReactiva=Read_Float_Eeprom(0x6666);  // parte de la memoria eeprom

    while (1) {
        if (bufferlleno) {
            bufferlleno=0;
            suma=0;
            sumaIntensidad=0;
            sumapotenciaactiva=0;
            for (i=0; i<100; i++) {
                if(nbuffer==1) {
                    dato=muestrasA[i];
                    datoIntensidad=muestrasC[i];
                } else {
                    dato=muestrasB[i];
                    datoIntensidad=muestrasD[i];
                }
                suma=suma+dato*dato;
                sumaIntensidad=sumaIntensidad+datoIntensidad*datoIntensidad;
                sumapotenciaactiva=sumapotenciaactiva+dato*datoIntensidad;
            }
            Vrms=(sqrt(suma*dato_v));
            Irms=(sqrt(sumaIntensidad*dato_i));
            PotenciaActiva=dato_p*sumapotenciaactiva;
            PotenciaAparente=Vrms*Irms;
            PotenciaReactiva=(sqrt((PotenciaAparente*PotenciaAparente)-(PotenciaActiva*PotenciaActiva)));
            EnergiaActiva=EnergiaActiva+PotenciaActiva*dato_e;
            EnergiaReactiva=EnergiaReactiva+PotenciaReactiva*dato_e;
            FactorPotencia=PotenciaActiva/PotenciaAparente;
            precio=EnergiaActiva*dato_pr;
        }
    }
}    