/*******************************************************************************
* Copyright (C) 2018 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/
#include "mbed.h"
#include "MAX14690.h"
#include "max32630fthr.h"
#include "USBSerial.h"

MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);

DigitalOut rLED(LED1);
DigitalOut gLED(LED2);
DigitalOut bLED(LED3);

//AnalogIn   ain_0(AIN_0);
//AnalogIn   ain_1(AIN_1);
AnalogIn   ain_4(AIN_4);
AnalogIn   ain_5(AIN_5);

const float battery_max = 4.20; //maximum voltage of battery
const float battery_min = 3.0;  //minimum voltage of battery before shutdown
uint8_t output = 0;
    
//DigitalIn vref(P1_4);
//I2C i2cBus(I2C2_SDA, I2C2_SCL);  // P5_7, P6_0
 
//MAX14690 max14690(&i2cBus);
  
// main() runs in its own thread in the OS
// (note the calls to Thread::wait below for delays)
/**
* @brief Sample main program for MAX14690
* @version 1.0000.0
*
* @details Sample main program for MAX14690
* The prints are sent to the terminal window (9600, 8n1).
* The program initializeds the LED to blue-green.
* If the program is successful at initializing the PMIC
* then it prints out a successful message, and if not, then
* it turns on the red LED and prints an error message.
* To run the program, drag and drop the .bin file into the 
* DAPLINK folder. After it finishes flashing, cycle the power or 
* reset the Pegasus after flashing by pressing the button on
* the Pegasus next to the battery connector or the button
* on the MAXREFDES100HDK.
*/
int main()
{
    DigitalOut rLED(LED1, LED_OFF);
    DigitalOut gLED(LED2, LED_OFF);
    DigitalOut bLED(LED3, LED_OFF);
    
    Serial pc(P3_1, P3_0);            // Use USB debug probe for serial link
    pc.baud(115200);                    // Baud rate = 115200
    
    bLED = LED_ON;
    gLED = LED_ON;

    /*i2cBus.frequency(400000);

    max14690.ldo2Millivolts = 3300;
    max14690.ldo3Millivolts = 3300;
    max14690.ldo2Mode = MAX14690::LDO_ENABLED;
    max14690.ldo3Mode = MAX14690::LDO_ENABLED;
    max14690.monCfg = MAX14690::MON_BAT;
    if (max14690.init() == MAX14690_ERROR) {
        pc.printf("Error initializing MAX14690.\r\n");
        bLED = LED_OFF;
        gLED = LED_OFF;
        rLED = LED_ON;
    } else {
        pc.printf("MAX14690 PMIC initialization is succesful.\r\n");
        gLED = LED_OFF;
    }*/
    while(1)
    {
        pc.printf("MAX14690 PMIC initialization is Done.\r\n");
      //  pc.printf("analog read 0 %3.4f\n", ain_4.read());
      //  pc.printf("percentage: %3.3f%%\n", ain_4.read() * 100.0f);
       // pc.printf("normalized: 0x%04X \n", ain_4.read_u16());
        
        unsigned short raw;
        raw = ain_4.read_u16();
        float vin;

       vin = ((raw*5*1.2)/ 65535.0);
       pc.printf("battery voltage is: %3.1f\n", vin);
       
       output = ((vin - battery_min) / (battery_max - battery_min)) * 100;
    if (output < 100)
        pc.printf("percentage: %i\n",output); 
    else
        pc.printf("percentage: 99\n"); 
        
        wait(5);
        
        
        }
}

