#include "mbed.h"
#include "Map.hpp"


DigitalOut led_green(LED1);
DigitalOut led_red(LED2);

InterruptIn user_button(USER_BUTTON);
AnalogIn ph (PB_0);
Serial pc (USBTX, USBRX);

float buf[10], temp;
float avg;
float phval;

Map map (0, 1.0f, 0, 14.0f);

int main()
{
    pc.baud(9600);
    
    while (1) {
        
        for (int i = 0; i < 10; i++) {          //read values from sensor
            buf[i] = ph.read();
            //pc.printf("read %.2f\n\r", buf[i]);
            wait(0.1);
        }// end for 1
        for (int i = 0; i < 9;i++) {            // sort values from smallest to lowest
            for(int j = i+1; j < 10; j++) {
                if (buf[i] > buf[j]) {
                 temp = buf[i];                 // shift data
                 buf[i] = buf[j];
                 buf[j] = temp;   
                
                } // end if 3
            } //end for 2
        }//end for 1
        
        avg = 0;
        for (int i = 2; i < 8; i++) {           // average 6 centre values
            avg +=buf[i];
        }// end for 1
        avg = avg/6;
        avg = avg - 0.15f;
        pc.printf("avg = %.6f\n\r", avg);
        phval = map.Calculate(avg);
        pc.printf("pH = %.2f\n\r", phval);                   
        }// end while 1
}// end main
