 /*Program Example 4: Program which runs two time-based tasks
 */
 #include "mbed.h"
 Timer timer_fast; // define Timer with name "timer_fast"
 Timer timer_slow; // define Timer with name "timer_slow"
 DigitalOut out1(D3);
 DigitalOut out2(D5);

 void task_fast(void); //function prototypes
 void task_slow(void);

 int main()
 {
     timer_fast.start(); //start the Timers
     timer_slow.start();
     while (1) {
         if (timer_fast.read_ms()>1) { //test Timer value
         task_fast(); //call the task if trigger time is reached
         timer_fast.reset(); //and reset the Timer
     }
         if (timer_slow.read_ms()>1000) { //test Timer value
             task_slow();
             timer_slow.reset();
         }
     }
 }
 void task_fast(void)
 {
 out1 = !out1;
 }
 void task_slow(void)
 {
 out2 = !out2;
 }