// Example to set up an interrupt based on the LPC TIMER0 match register, sford
 #include "C12832_lcd.h"
#include "mbed.h"

// Definitionen
#define n 9 // n ist die Ordnung des Filters,
        //         erfordert n+1 Koeffizienten
int i;
float x,y;    // Eingang, Ausgang
int PZ;     // zeigt auf Ringpuffer p
int PA;     // zeigt auf Koeffizienten a,b
float p[n+1];   // Ringpuffer mit n Speichern (n=0 unbenutzt)
float a[n+1];   // Koeffizienten

DigitalOut myled(LED1);
DigitalOut mypin(p21);
AnalogIn input(p19);

C12832_LCD lcd;

void Init_Filter();
float FIR(float x);

volatile uint16_t poti, poti_f;

void myhandler() {                                      //Interrupt Service Routine, wird durch den Timer0_Vektor gestartet
     mypin=1;
   
    // do something!
    poti= input.read_u16();
   
    poti_f=FIR(poti);
      mypin=0;
   
    // clear the TIMER0 interrupt
    LPC_TIM0->IR = 1;                                //Reset Timer0 Interrupt Flag
}

int main() {
    // power up TIMER0 (PCONP[1])
    LPC_SC->PCONP |= 1 << 1; 

    // reset and set TIMER0 to timer mode
    LPC_TIM0->TCR = 0x2;  
    LPC_TIM0->CTCR = 0x0; 
    
    // set no prescaler
    LPC_TIM0->PR = 0;

    // calculate period (1 interrupt every second)
    uint32_t period = SystemCoreClock / 4;                              //Period ist die Periodenlänge     /4 ursprünlgich für eine Sekunde
                                                                        //SystemCoreClock ist eine Konstante mit dem Wert

    // set match register and enable interrupt    
    LPC_TIM0->MR0 = period/10000;                                             //Vergleichswert des Timers wird gesetzt mit Period
    LPC_TIM0->MCR |= 1 << 0;    // interrupt on match                   //Einstellung, dass ein Interrupt ausgelöst wird beim Match
    LPC_TIM0->MCR |= 1 << 1;    // reset on match                       //Einstellung, dass der Timerwert auf Null zurückgesetzt wird bei Match

    // enable the vector in the interrupt controller
    NVIC_SetVector(TIMER0_IRQn, (uint32_t)&myhandler);                  //Zuordunung der InterruptServiceRoutine (Handler) zum Vektor von Timer0
    NVIC_EnableIRQ(TIMER0_IRQn);                                        //Timer Interrupt wird enabled

    // start the timer
    LPC_TIM0->TCR = 1;                                                  //Einstellung, dass der Timer gestartet wird
    
    Init_Filter();

    // hang around!   
    while(1) {    
    
       lcd.cls();
       lcd.locate(0,0);
       lcd.printf("%d",poti_f);                                                       //while Schleife, in der die erste LED getoggelt wird
        
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}

void Init_Filter(){
    // ***** Initialisierung am Anfang der Main-Routine
// füer gleitende Mittelwertbildung:

            a[  0]=  0.1;
            a[  1]=  0.1;
            a[  2]=  0.1;
            a[  3]=  0.1;
            a[  4]=  0.1;
            a[  5]=  0.1;
            a[  6]=  0.1;
            a[  7]=  0.1;
            a[  8]=  0.1;
            a[  9]=  0.1;

  for (PZ=1 ; PZ<=n ; PZ=PZ+1) p[PZ]=0; //Speicher loeschen
  PZ = 1;           // erstes Ringpufferelement definieren
    
    }

float FIR(float x){
    
//********* Beginn des Digitalfilters, Eingang ist x *******
       
    
  y = a[0]*x;           // Aktuellen Messwert mit Koeff. multipliz.
  for (PA=1 ; PA<=n ; PA = PA+1) // PA rotiert rechts herum von 1 bis n
      {
      y = y + a[PA]*p[PZ];  // Teilprodukte aufsummieren
      if (PZ<=1) PZ = n; else PZ = PZ -1;   // PZ rotiert links herum
      }
  if (PZ<n) PZ = PZ +1; else PZ = 1; // PZ weiter fuer naechsten Messwert
  p[PZ] = x;           // Aktuellen Messwert in Ringpuffer einschieben
  
  return y;
    //mypin = 0; // FIR dauert 12 µs
//********* Ende des Digitalfilters, Ausgang ist y *********
    
    
    }