// Example to set up an interrupt based on the LPC TIMER0 match register, sford
 
#include "mbed.h"

DigitalOut myled(LED1);
DigitalOut irqled(LED2);

void myhandler() {
    // do something!
    irqled = !irqled;
    
    // clear the TIMER0 interrupt
    LPC_TIM0->IR = 1;
}

int main() {
    // power up TIMER0 (PCONP[1])
    LPC_SC->PCONP |= 1 << 1; 

    // reset and set TIMER0 to timer mode
    LPC_TIM0->TCR = 0x2;  
    LPC_TIM0->CTCR = 0x0; 
    
    // set no prescaler
    LPC_TIM0->PR = 0;

    // calculate period (1 interrupt every second)
    uint32_t period = SystemCoreClock / 20; 

    // set match register and enable interrupt    
	LPC_TIM0->MR0 = period;
	LPC_TIM0->MCR |= 1 << 0;    // interrupt on match
	LPC_TIM0->MCR |= 1 << 1;    // reset on match

    // enable the vector in the interrupt controller
    NVIC_SetVector(TIMER0_IRQn, (uint32_t)&myhandler);
    NVIC_EnableIRQ(TIMER0_IRQn);

    // start the timer
    LPC_TIM0->TCR = 1;

    // hang around!   
    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
