//オンボードLEDの使用宣言
DigitalOut LED[] = {DigitalOut(LED1),
                    DigitalOut(LED2),
                    DigitalOut(LED3),
                    DigitalOut(LED4),
                   };

//デバック用シリアル
Serial pc(USBTX, USBRX);
Serial XBEE(p28, p27);

//CAN用 (rd, td)
Mycan can(p30, p29);

//sbus用 (tx, rx)
SBUS sbus(p13, p14);

//メカナム逆運動学モデルのヤコビアン
float jacobian[4][3] = {{ 1, -1, -1},
                        { 1,  1, -1},
                        {-1,  1, -1},
                        {-1, -1, -1}
                       };
                       
//(逆運動学モデル, ホイールの計算100%定義)
DriveController mecanum(jacobian, 0.95);

//(計算周期時間[s], sla, sld)
IMU imu(0.005, p9, p10);

//(pwmPin, direPin)
MDD Motor[4] = {  MDD(p22, p21),
                  MDD(p24, p23),
                  MDD(p25, p20),
                  MDD(p26, p19)
               };
               
Timer timer;

//(A相, B相)
RotaryEncoder enc[3] = {RotaryEncoder(p5 , p6 , &timer, 100),
                        RotaryEncoder(p18, p17, &timer, 100),
                        RotaryEncoder(p16, p15, &timer, 100),
                       };

//(trig, echo)     
USS uss(p11, p12);
             
//コントローラー入力のための構造体
typedef struct controller {
    float LX, LY, RX, RY;
    int A,B,C,D,E,F,G,H;
    int fail_safe;
} controller;